﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public static class Extensions {

 
    public static void SetUIPosition(this RectTransform uiTrans, Vector3 uipos)
    {
        uiTrans.transform.position = uipos;
        var ap = uiTrans.anchoredPosition3D;
        ap.z = 10;
        uiTrans.anchoredPosition3D = ap;
    }

    public  static string GetArrStr<T>(this T[] arr)
    {
        string str = "";
        foreach(var e in arr)
        {
            str += e + ",";
        }
        if(str.Length > 0)
            str = str.Substring(0, str.Length - 1);
        return $"[{str}]";
    }
    public static string GetListStr<T>(this List<T> arr)
    {
        return GetArrStr(arr.ToArray());
    }

    public static bool IsCompareWith(this float f1, float f2,int pow = 6)
    {
        long f1L = (long)(f1 * Mathf.Pow(10, pow));
        long f2L = (long)(f2 * Mathf.Pow(10, pow));

        return f1L == f2L;
    }
}

public static class ActionExt
{
    public static Func<ValueTuple> ToFunc(this Action action)
    {
        Func<ValueTuple> func = () => { action(); return new ValueTuple(); };
        return func;
    }
    public static Func<T, ValueTuple> ToFunc<T>(this Action<T> action)
    {
        Func<T, ValueTuple> func = (t) => { action(t); return new ValueTuple(); };
        return func;
    }
    public static Func<T1, T2, ValueTuple> ToFunc<T1, T2>(this Action<T1, T2> action)
    {
        Func<T1, T2, ValueTuple> func = (t1, t2) => { action(t1, t2); return new ValueTuple(); };
        return func;
    }
}

