using System.Runtime.InteropServices.WindowsRuntime;

public abstract class ActionTransition : Transition
{
    protected  ActionFSMState fromAction => this.from as ActionFSMState;
    protected  ActionFSMState toAction => this.to as ActionFSMState;

    protected PlayerEntity role => toAction.role;
    
    protected ActionTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    }
}

/// <summary>
/// normal -> jumpToLevel
/// </summary>
public class MeetSignTransition : ActionTransition
{
    private int m_Sign;
    
    public MeetSignTransition(int sign,ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        m_Sign = sign;
    }

    public override bool meedSign(int sign)
    {
        return sign == m_Sign;
    }
}
/*

/// <summary>
/// run -> idle
/// </summary>
public class Run2IdleTransition : ActionTransition
{
    public Run2IdleTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    }

    public override bool meedCondition()
    {
        return this.role.moveVec.sqrMagnitude <= 0;
    }
}

/// <summary>
/// ant -> byHit
/// </summary>
public class Any2ByHitTransition : ActionTransition
{
    public Any2ByHitTransition(ActionFSMState from ,ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedSign(int sign)
    {
        return sign == ActionType.byHit;
    }
}

/// <summary>
/// 过程型动作过渡
/// </summary>
public class ProgressActionTransition:ActionTransition
{
    public ProgressActionTransition(ProgressActionFSMState from, ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedCondition()
    {
        ProgressActionFSMState from = this.from as ProgressActionFSMState;

        return from.finished;
    }
}

public class Any2DieTransition : ActionTransition
{
    public Any2DieTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    }

    public override bool meedCondition()
    {
        return this.role.dead;
    }
}

/// <summary>
/// ant -> attack
/// </summary>
public class Any2AttackTransition : ActionTransition
{
    public Any2AttackTransition(ActionFSMState from, ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedSign(int sign)
    {
        return sign == ActionType.policeAttack;
    }
}

/// <summary>
/// ant -> foundTargetStay
/// </summary>
public class Any2FoundTargetStayTransition : ActionTransition
{
    public Any2FoundTargetStayTransition(ActionFSMState from, ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedSign(int sign)
    {
        return sign == ActionType.foundTargetStay;
    }
}


/// <summary>
/// ant -> loseTargetStay
/// </summary>
public class Any2LoseTargetStayTransition : ActionTransition
{
    public Any2LoseTargetStayTransition(ActionFSMState from, ActionFSMState to) : base(from, to)
    {
        
    }


    public override bool meedSign(int sign)
    {
        return sign == ActionType.loseTargetStay;
    }
}*/