﻿
/*********************************************************************
* 版权所有 (C)2019, 深圳多游开发团队。
* 
* 文件名称： // FSMState.cs
* 内容摘要： // 该文件是 状态基类
* 其它说明： // 
* 当前版本： // V0.1
* 作    者： // Will.Wang
* 创建日期： // 2019/06/04
* 
* 修改记录1：// 修改历史记录，包括修改日期、修改者及修改内容
*    修改日期：
*    版 本 号：
*    修 改 人：
*    修改内容： 
* 修改记录2：…
**********************************************************************/

using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using UnityEngine;

/// <summary>
/// 转换条件
/// </summary>
public abstract  class Transition
{
    private FSMState m_From;
    public FSMState from => m_From;
    
    private FSMState m_To;
    public FSMState to => m_To;
    
    public int toState => m_To != null ?m_To.ID : FSMState.NullStateID;
    
    public Transition(FSMState from,FSMState to)
    {
        m_From = from;
        m_To = to;
    }
    
    public virtual bool meedCondition() => false;

    public virtual bool meedSign(int sign) => false;
}



public abstract class FSMState
{
    protected FSMSystem fsm;
    private List<Transition> map = new List<Transition>();
    public List<Transition> transMap => map;
    
    public abstract int ID { get; }

    public virtual bool moveable { get; }

    public const int NullStateID = -100;

    protected FSMState(FSMSystem fsm)
    {
        this.fsm = fsm;
        fsm.AddState(this);
    }
    /// <summary>
    /// 添加 状态转换
    /// 添加可能切换状态的map {条件，状态}
    /// 切换的时候通过自己的状态,根据过渡条件跳到新的状态
    /// </summary>
    /// <param name="trans"></param>
    /// <param name="id"></param>
    public void AddTransition(Transition trans)
    {
        if (trans == null)
        {
            Debug.LogError("FSMState ERROR: Null Transition is not allowed for a real transition");
            return;
        }

        if (trans.toState == NullStateID)
        {
            Debug.LogError("FSMState ERROR: NullStateID is not allowed for a real ID");
            return;
        }
        if (map.Contains(trans))
        {
            Debug.LogError("FSMState ERROR: State " + ID.ToString() + " already has transition " + trans.ToString() +
                           "Impossible to assign to another state");
            return;
        }
        map.Add(trans);
    }
    /// <summary>
    /// 删除 状态转化
    /// </summary>
    /// <param name="trans"></param>
    public void DeleteTransition(Transition trans)
    {
        if (trans == null)
        {
            Debug.LogError("FSMState ERROR: Null Transition is not allowed");
            return;
        }

        if (map.Contains(trans))
        {
            map.Remove(trans);
            return;
        }
        Debug.LogError("FSMState ERROR: Transition " + trans.ToString() + " passed to " + ID.ToString() +
                       " was not on the state's transition list");
    }
/*    /// <summary>
    /// 获取 转换条件状态
    /// </summary>
    /// <param name="trans"></param>
    /// <returns></returns>
    public int GetOutputState(Transition trans)
    {
        if (map.ContainsKey(trans))
        {
            return map[trans];
        }
        return NullStateID;
    }*/
    /// <summary>
    /// 当前状态开始时 执行
    /// </summary>
    public virtual void DoBeforeEntering() { }
    /// <summary>
    /// 当前状态离开时 执行
    /// </summary>
    public virtual void DoBeforeLeaving() { /*Debug.Log("状态切换"); */}
    /// <summary>
    /// 当前状态的具体执行 每帧调用
    /// </summary>
    public virtual void Update() { }

}