﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TipsBase : MonoBehaviour {
    
    public UnityEngine.UI.Text contentText;

    protected UIAnim m_UIAnim;

    public AnimationCurve animCurve;

    public float showTime = 2f;

    protected virtual void Awake()
    {
        m_UIAnim = gameObject.GetComponent<UIAnim>();
        if (m_UIAnim == null) m_UIAnim = gameObject.AddComponent<UIAnim>();
        m_UIAnim.InitCurve(animCurve);

        if (contentText == null)
            contentText = GetComponentInChildren<UnityEngine.UI.Text>();
    }
    // Use this for initialization
    void Start () {
		
	}
    public virtual void SetContent(string content)
    {
        contentText.text = content;
    }
    // Update is called once per frame
    void Update () {
		
	}
}
