﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class ShowHideUI : MonoBehaviour {
    
    public bool isShowing { get; set; }
    public float showAnimTime = 0.2f;
    public float hideAnimTime = 0.2f;


    protected abstract void _Show(System.Action onEnd);

    public virtual void Show(System.Action onEnd)
    {
        isShowing = true;

        _Show(onEnd);
    }
    public virtual void Hide(System.Action onEnd)
    {
        isShowing = false;

        _Hide(onEnd);
    }
    protected abstract void _Hide(System.Action onEnd);

}
