﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AlphaShowHideUI : ShowHideUI
{

    protected UIAnim m_UIAnim;

    protected virtual void Awake()
    {
        CheckUIAnimNull();

        var rectTransform = GetComponent<RectTransform>();
        UIAnim.GetImgTxtAlpha(rectTransform, out imgAlphas, out txtAlphas, out rawAlphas);
    }

    void CheckUIAnimNull()
    {
        if (m_UIAnim == null) m_UIAnim = GetComponent<UIAnim>();
        if (m_UIAnim == null) m_UIAnim = gameObject.AddComponent<UIAnim>();

    }
    List<float> imgAlphas;
    List<float> txtAlphas;
    List<float> rawAlphas;
    protected override void _Show(System.Action onEnd)
    {
        CheckUIAnimNull();
        
        var trans = GetComponent<RectTransform>();
        m_UIAnim.SetImgTxtAlpha(trans, 0);

        if (gameObject.activeInHierarchy)
            m_UIAnim.UIAlpha(trans, imgAlphas, txtAlphas, rawAlphas,this.showAnimTime, onEnd, UIAnim.EaseType.Curve);
    }

    protected override  void _Hide(System.Action onEnd)
    {
        CheckUIAnimNull();

        if (gameObject.activeInHierarchy)
        {
            m_UIAnim.UIAlpha(GetComponent<RectTransform>(), 0, hideAnimTime, onEnd, UIAnim.EaseType.Curve);
        }
    }

    public void SetAlpha(float alpha)
    {
        m_UIAnim.SetImgTxtAlpha(GetComponent<RectTransform>(), alpha);
    }

}
