﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerControl : MonoBehaviour
{
    public float speed = 10f;
    private Vector3 startpoint;
    private Vector3 endpoint;
    private Vector3 mouseUpEnd;
    public  Vector3 dir;

    public FoodControl[] foods;
    public Transform items;

    private bool isfric = false;

    void Start()
    {
        foods = items.GetComponentsInChildren<FoodControl>();
    }

    
    void Update()
    {
        if (Input.GetMouseButtonDown(0)) 
        {
            startpoint = new Vector3(Screen.width/2,Screen.height/7,0);
          isfric = true;
        } 
        if (Input.GetMouseButton(0)) 
        {
            endpoint = Input.mousePosition;      
        }
     
        if (Input.GetMouseButtonUp(0)) 
        {
            mouseUpEnd = Input.mousePosition;
            Throw(mouseUpEnd.y - endpoint.y);
            //  startpoint = endpoint; 
            isfric = false;
        }
        Vector3 dirs = endpoint - startpoint;
        move(dirs * 0.001f);
        this.transform.position = Vector3.MoveTowards(this.transform.position, dir, speed * Time.deltaTime);


        //if (dir.sqrMagnitude>0&& ismove==true ) 
        //{
        //    this.transform.Translate(dir * speed * Time.deltaTime);
        //    clampMove();
        //}


        if (isfric)
        {
          

                for (int i = 0; i <= foods.Length - 1; i++)
                {
                    foods[i].friction(dir,speed);
                }
        
        }
    }

   



    void clampMove() 
    {
        //if (this.transform .position .x>0.45f) 
        //{
        //    this.transform.position = new Vector3(0.45F,0,this.transform.position.z);
        //}
        //if (this.transform .position .x<-0.45f) 
        //{
        //    this.transform.position = new Vector3(-0.45F,0,this.transform.position .z);
        //}
        //if (this.transform.position.z>0.55F) 
        //{
        //    this.transform.position = new Vector3(this.transform.position.x,0,0.55f);
        //}
        //if (this.transform .position .z<-0.55F) 
        //{
        //    this.transform.position = new Vector3(this.transform.position .x,0,-0.55f);
        //}
        this.transform.position = new Vector3(Mathf.Clamp(this.transform.position.x ,-0.45F,0.45F),0,Mathf.Clamp(this.transform.position.z,-0.55F,0.55F));

    }
    void move(Vector3 dirs) 
    {
        float x = -dirs.x;
        float z = -dirs.y;
        if (x>=1) 
        {
            x = 1;
        }
        if (x<=-1) 
        {
            x = -1;
        }
        if (z>=1) 
        {
            z = 1;
        }
        if (z<=-1) 
        {
            z = -1;
        }
        dir = new Vector3(x,0,z);
    }
    
    void Throw(float DIS)
    {
     //  GameDebug.Log("距离为"+DIS+"时间为"+timer);

        if (DIS>=30f) 
        {     
            //  GameDebug.Log("癫锅了");
            for (int i=0; i <= foods.Length-1;i++) 
            {
                foods[i].IsFroce = true;
            }
            endpoint = startpoint ;
        }
    }

   

}
