﻿using System.Collections;
using System.Collections.Generic;
using System.Net;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.Serialization;


public class LaunchSceneDisplayController : DisplayController
{
/*    ViewControllerNav m_DisplayControllerNav;
    ViewControllerNav ViewControllerNav
    {
        get
        {
            if (m_DisplayControllerNav == null)
            {
                m_DisplayControllerNav = new GameObject("LaunchSceneNav").AddComponent<ViewControllerNav>();
                m_DisplayControllerNav.transform.SetParent(transform);
            }

            return m_DisplayControllerNav;
        }
    }*/
    LaunchPanel m_Panel;
    
    public GameObject fakeLoginLoadingAnim;
    
    public override void DidLoadDisplay()
    {
        base.DidLoadDisplay();
        
        if(m_Panel == null)
        {
            var pref = GameResourceManager.Load<LaunchPanel>(DisplayDefine.LaunchPanel);
            m_Panel = Instantiate<LaunchPanel>(pref,transform);
            
            m_Panel.Init(OnSplashEnd);
        }
    }
    
    /// <summary>
    /// 闪屏结束
    /// </summary>
    void OnSplashEnd()
    {
        var prefab = GameResourceManager.Load<GameObject>(GameResourceManager.fakeLoadingAnimPath);
        fakeLoginLoadingAnim = Instantiate<GameObject>(prefab, null);
        
        Invoke(nameof(GotoBattle),0.1f);
    }
    
    public override void WillHideDisplay()
    {
        base.WillHideDisplay();
        
        if (m_Panel)
        {
            Destroy(m_Panel.gameObject);
        }
        m_Panel = null;

/*        if (m_DisplayControllerNav)
            Destroy(m_DisplayControllerNav.gameObject);
        m_DisplayControllerNav = null;*/
        
        if(fakeLoginLoadingAnim)
            Destroy(fakeLoginLoadingAnim.gameObject);
        
        fakeLoginLoadingAnim = null;
    }
    
    
   
    public BattleSceneDisplayController GotoBattle()
    {
        return  Game.Instance.LoadCurLevelGame();
    }

}