using UnityEngine;

public class BattleUIWidgetInfoController : BattleWidgetInfoController
{
    BattleMainUI battleUI
    {
        get
        {
            if (!this) return null;
            return GetComponentInParent<BattleMainUI>();
        }
    }
    [SerializeField]
    Transform numInfoParent;

    [SerializeField]
    NumInfo numInfoPref;

    protected override void Start()
    {
        base.Start();
        
        if(numInfoPref)
            numInfoPref.gameObject.SetActive(false);
    }
 
    public NumInfo AddNumInfo(int showNum, Transform refer,Vector3 targetUVPos,bool follow,bool moveUp,string prex = "+",Color color = new Color())
    {
        if (!this) return null;

        var item = Instantiate<NumInfo>(numInfoPref, numInfoParent);
        item.gameObject.SetActive(true);
        item.Init(showNum, refer, battleUI.WorldPosToUICameraPos, targetUVPos,follow,moveUp,prex,color);
        return item;
    }

}