﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class UguiFPS : MonoBehaviour 
{
	[SerializeField]
	Text m_Text;

	private float m_UpdateTime = 0.5f;
	private float m_CurTime;
	private int m_LastFrameCount = 0;

	void Start ()
	{
		Application.targetFrameRate = 60;
		if (m_Text == null)
		{
			m_Text = this.GetComponent<Text>();
		}
	}

	void Update ()
	{
		m_CurTime += Time.deltaTime;

		if (m_CurTime >= 0.5f)
		{
			m_CurTime = 0f;

			int curFrameCount = Time.frameCount;
			int fps = Mathf.FloorToInt((curFrameCount - m_LastFrameCount) / m_UpdateTime);
			m_LastFrameCount = curFrameCount;

			if (m_Text == null)
			{
				m_Text = this.GetComponent<Text>();
			}
			if (m_Text != null)
			{
				m_Text.text = fps.ToString();
			}
		}
	}
}
