﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ScaleTips : TipsBase
{
    public TransformAnim m_TransformAnim;
    public Vector3 hideScale = new Vector3(1, 0, 1);
    System.Action m_OnShowEnd;

    protected override void Awake()
    {
        base.Awake();

        if(m_TransformAnim == null) m_TransformAnim = gameObject.GetComponent<TransformAnim>();
        if (m_TransformAnim == null) m_TransformAnim = gameObject.AddComponent<TransformAnim>();

        m_TransformAnim.SetCurve(this.animCurve);

        transform.localScale = hideScale;
    }

    public void SetContent(string content,System.Action onShowEnd)
    {
        base.SetContent(content);

        m_OnShowEnd = onShowEnd;

        StartCoroutine(PlayShowAnim());
    }
    [ContextMenu("TestShow")]
    void TestShow()
    {
        StartCoroutine(PlayShowAnim());
    }

    IEnumerator PlayShowAnim()
    {
        AudioManager.instance.PlayUISound(Audio.floatTips);

        //transform.localScale = hideScale;

       // yield return 0;

        const float fadeInTime = 0.2f;
        m_TransformAnim.ScaleTo(transform, Vector3.one, fadeInTime, null);

        yield return new WaitForSeconds(showTime - fadeInTime);
        
        const float fadeOutTime = 0.2f;
        m_TransformAnim.ScaleTo(transform, hideScale, fadeOutTime, OnAnimEnd);
    }

    void OnAnimEnd()
    {
        if (m_OnShowEnd != null)
            m_OnShowEnd();
        else
            Destroy(gameObject);
    }
}
