﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PCResolutionSet : MonoBehaviour 
{
#if UNITY_STANDALONE && !UNITY_EDITOR

	int m_ScreenWidth;
	int m_ScreenHeight;

	void Awake ()
	{
		m_ScreenWidth = Screen.width;
		m_ScreenHeight = Screen.height;
	}

	const int targetWidth = 9;
	const int targetHeight = 16;

	void LateUpdate ()
	{
		if (m_ScreenWidth != Screen.width || m_ScreenHeight != Screen.height)
		{
			m_ScreenWidth = Screen.width;
			m_ScreenHeight = Screen.height;

			this.ResetTo9_16();
		}
	}

	void ResetTo9_16 ()
	{
		int width = targetWidth * Screen.height / targetHeight;
		Screen.SetResolution(width, Screen.height, FullScreenMode.Windowed);
	}

#endif
}
