using System;
using System.Collections.Generic;
using UnityEngine;

public class DieGaoGaoGameUser:GameUser
{

    /// <summary>
    /// 
    /// </summary>
    private int m_Number;
    public int Number => m_Number;


    /// <summary>
    /// 
    /// </summary>

    private List<int> m_Items;
    public List<int> items => m_Items;

    protected override void _Init(LocalUserData localUserData)
    {

         base._Init(localUserData);
         this.m_Number = localUserData.Number;
         if (localUserData.items != null)
            this.m_Items = new List<int>(localUserData.items);
         else
            this.m_Items = new List<int>();

    }
    protected override LocalUserData _GetLocalUserData()
    {
        var user = this;

        LocalUserData localUserData = new LocalUserData();
        localUserData.id = user.id;
        localUserData.coin = user.coin;
        localUserData.diamond = user.diamond;
        localUserData.level = user.level;
        localUserData.Height = user.height;
        localUserData.Number = user.Number;

        if (user.levelStars != null)
        {
            localUserData.levelStars = user.levelStars.ToArray();
        }
        if (user.items != null)
            localUserData.items = user.items.AsArray();

        return localUserData;
    }


    public void AddItem(int itemId)
    {
        this.m_Items.Add(itemId);

        UpdateLocalData();
    }
    public void RemoveItem(int itemId)
    {
        this.m_Items.Remove(itemId);

        UpdateLocalData();
    }
    public int[] GetItems() 
    {
        return m_Items.ToArray();
    }


    public static Action<int> onUpdateNumber;
    public void UpdateNumber(int Number,bool updateRemote=true) 
    {
        GameDebug.Log($"{m_Number} Ϊ: {Number}");
        this.m_Number = Number;
        UpdateLocalData();
        onUpdateNumber?.Invoke(Number);
    }

    public void ReduceNum(int num) 
    {
        int number = this.m_Number - num;
        GameDebug.Log($"Number :{m_Number} ȥ{num} to:{number}");
        number = Mathf.Max(0,number);
        UpdateNumber(number);
    }

    public void AddNumber(int num) 
    {
        int number = m_Number + num;
        number = Mathf.Max(0,number);
        UpdateNumber(number);
    }


}