﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FoodControl : MonoBehaviour
{

    private MeshCollider _collider;
    private Rigidbody _rigidbody;

    public float angle = 60;
    public float Force = 50;

    public bool IsFroce=false;
    private Vector3 dir;

    void Start()
    {
        _collider = this.GetComponent<MeshCollider>() ? this.GetComponent<MeshCollider>() : this.gameObject.AddComponent<MeshCollider>();
        _collider.convex = true;
        _rigidbody = this.GetComponent<Rigidbody>() ? this.GetComponent<Rigidbody>() : this.gameObject.AddComponent<Rigidbody>();
        dir = new Vector3(0, Mathf.Tan(angle* (Mathf.PI * 2 / 360)),1);
       
    }

   
    void Update()
    {
     
    }

    private void FixedUpdate()
    {
        if (IsFroce)
        {
            AddForece();
        }
    }
     void AddForece() 
    {
        this.gameObject.GetComponent<Rigidbody>().AddForce(dir * Force * Time.deltaTime * 100f);
        IsFroce = false;
    }
}
