using UnityEngine;

public class HoppingBattleSceneEditorTest: BattleSceneEditorTest
{
    [SerializeField]
    private HoppingDataConfig m_DataConfig;

    protected override void InitBattle(BattleData data)
    {
        m_Controller.Init(data, testPlayerId, battle3DScene);
        
        m_Controller.Invoke("GameStart",1);
    }

    protected override BattleController NewBattleController()
    {
        var battleContoller = new GameObject("BattleController").AddComponent<HoppingBattleController>(); 
        transform.SetParent(battleContoller.transform);
        //battleContoller.dataConfig = m_DataConfig;
        
        return battleContoller;
    }

    protected override BattleData GetTestData()
    {
        BattleData battleData = new BattleData();
        battleData.mapData = new BattleMapData();
        battleData.mapData.mapId = battle3DScene.mapId;
        battleData.dataConfig = m_DataConfig;
        return battleData;
    }
}