﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;



public static class ViewEntityType
{
    public const int player = 1;
}


public partial class HoppingBattleController : BattleController
{
    private List<PlayerEntity> m_Players = new List<PlayerEntity>();   
    public HoppingBattle3DScene HoppingBattle3DScene => this.battle3DScene as HoppingBattle3DScene;
    public HoppingSceneType sceneType => HoppingBattle3DScene.sceneType;
    
    private HoppingDataConfig m_DataConfig;
    private HoppingDataConfig hoppingDataConfig => dataConfig as HoppingDataConfig;
    
    public override DataConfig dataConfig
    {
        get { return m_DataConfig; }
    }

    #region 
//    CubeToucheControl m_CubeToucheControl;
  //  public CubeToucheControl cubeToucheControl => m_CubeToucheControl;



    #endregion
    //LifeControl m_LifeControl;
    //public LifeControl lifeControl => m_LifeControl;

 

    public static LayerMask layerPlayerMask => LayerMask.GetMask("Player");
    public static int layerPlayer => LayerMask.NameToLayer("Player");

  
    protected override void LateInit(BattleData battleData)
    {
        this.m_DataConfig = battleData.dataConfig as HoppingDataConfig;
        
        int maxWindCount = 3;
        
        #if UNITY_EDITOR
        maxWindCount = 1;
#endif

       

        ViewEntity[] mapEditEntities = battle3DScene.GetComponentsInChildren<ViewEntity>();
        
        for (int i = 0; i < mapEditEntities.Length; i++)
        {
            ViewEntity entity = mapEditEntities[i];

            //GameDebug.Log($"LateInit entity:{entity.name}");
            if (entity.entityType == ViewEntityType.player)
            {
                PlayerEntity widgetEntity = entity as PlayerEntity;
                widgetEntity.Init(m_DataConfig);
                
                m_Players.Add(widgetEntity);
            }
        }

      //  m_CubeToucheControl = GetComponentInChildren<CubeToucheControl>();
   

      /*  this.m_AllLife = m_DataConfig.AllLife;
        this.CurrentLife = m_AllLife;
        m_NumberAll = HoppingBattle3DScene.NumberMax;
        this.CurrentNumber = 0;

   */
    }

  
  
  
  
  

    public override void ContionGame()
    {

        m_State = State_Gaming;
    }

    public PlayerEntity GetMe()
    {
        return GetPlayer(myPlayerId);
    }
    
    public PlayerEntity GetPlayer(long playerId)
    {
        return m_Players.Find(e => e.playerId == playerId);
    }

  

}

public partial class HoppingBattleController
{
   
   /* int m_AllLife = 3;
    public int AllLife => m_AllLife;

    public int CurrentLife = 3;

    int m_NumberAll;
    public int NumberAll => m_NumberAll;
    public int CurrentNumber;
    */

    internal void ChangeLife()
    {

     
      
    }
    internal void AddLife(int Life) 
    {
        if (battle3DScene.mapId <= 3) return;
      
    }


    internal void AddNumber(int num) 
    {

        if (battle3DScene.mapId > 3) return;

    
        //if (CurrentNumber<=0) 
        //{
        //    CurrentNumber = 0;
        //}
    }

    
    internal void ChangeNumber() 
    {
  
    }
    /// <summary>
    /// 是否结束
    /// </summary>
    public override bool battleFinished
    {
        
        get
        {

                return false;
            
           // return  CurrentLife <= 0;
            

            //var me = GetMe();

            //if (me)
            //    return me.state == PlayerState.State_Win || me.state == PlayerState.State_Lose;
            //else
            //    return false;
        }
    }
    

    /// <summary>
    /// 获取结果数据
    /// </summary>
    /// <returns></returns>
    public override BattleResult GetBattleResult()
    {
        BattleResult result = new BattleResult();
        
        result.level = this.mapId;
        //result.star;
        //result.score = GetMe().score;

      /*  if (m_winEntity.number >= m_loseEntity.number)
        {
            result.win = true;
        }
        else 
        {
            result.win = false;
        }

        if (m_winEntity.number == NpcEntitys.Length)
        {
            result.star = 3;
        }
        else 
        {
            result.star = 2;
        }
      */
    
        GameDebug.Log($"战斗关卡{result.level} 结果：{result.win}");
  
    
        return result;
    }
  
}