﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

[System.Serializable]
public struct LaunchImage
{
    public Sprite sprite;
    public float showTime;
}

public class LaunchPanel : MonoBehaviour {

    public Image splashImg;
    
    public LaunchImage[] launchImages;

    UIAnim m_UIAnim;
    UIAnim uiAnim
    {
        get
        {
            if (m_UIAnim == null)
                m_UIAnim = gameObject.AddComponent<UIAnim>();

            return m_UIAnim;
        }
    }

    private bool m_InAnim;
    private int m_CurIndex = -1;
    private float m_LastBeginShowTime;
    private bool m_ImageHasShowedEnd;
    
    Action m_AnimEnd;

    // Use this for initialization
    void Start () {

      
    }

    private void OnDestroy()
    {
        m_AnimEnd = null;
    }

    public void Init(Action onEnd)
    {
        m_AnimEnd = onEnd;
        
        if (launchImages.Length == 0)
        {
            m_AnimEnd?.Invoke();
        }
        else
        {
            ShowLaunchImg(launchImages, 0);
        }
    }

    private const int BeginIndex = -1;
    
    void ShowLaunchImg(LaunchImage[] launchImages,int index)
    {
        if (launchImages == null || launchImages.Length ==0)
        {
            return;
        }

        m_InAnim = true;
        m_CurIndex = BeginIndex;
        
        /*
         协程改成了Update
         StartCoroutine(ShowImg(this.splashImg, launchImages[index],
            ()=>
            {
                ShowLaunchImg(launchImages,++index);
            }));*/
    }

    void OnImageBeginShow(LaunchImage launchImage)
    {
        GameDebug.LogShowy($"显示Image:{launchImage.sprite.name}   time：{Time.realtimeSinceStartup}");
        splashImg.sprite = launchImage.sprite;
        splashImg.SetNativeSize();
        uiAnim.UIAlpha(splashImg.rectTransform, 1, 0.2f);
    }

    void OnImageEndShow(LaunchImage launchImage)
    {
        GameDebug.LogShowy($"隐藏Image:{launchImage.sprite.name}   time：{Time.realtimeSinceStartup}");
        uiAnim.UIAlpha(splashImg.rectTransform, 0, 0.2f, null);
    }

    // Update is called once per frame
	void Update ()
    {
        if (m_InAnim)
        {
            if (launchImages == null || m_CurIndex >= launchImages.Length)
            {
                try
                { 
                    if (m_AnimEnd != null)
                        m_AnimEnd();
                }
                catch (Exception e)
                {
                    GameDebug.LogError(e);
                }

                m_InAnim = false;
                return;
            }

            if (m_CurIndex == BeginIndex)
            {
                ///开始
                m_CurIndex = 0;

                LaunchImage firstImage = launchImages[m_CurIndex];
                OnImageBeginShow(firstImage);
                
                m_LastBeginShowTime = Time.realtimeSinceStartup;
                m_ImageHasShowedEnd = false;
            }
            
            LaunchImage launchImage = launchImages[m_CurIndex];

            float elapsedTime = Time.realtimeSinceStartup - m_LastBeginShowTime;
            if (elapsedTime > launchImage.showTime)
            {
               // GameDebug.LogShowy($"elapsedTime:{elapsedTime}  launchImage:{launchImage.sprite.name} time：{launchImage.showTime}");

                if (elapsedTime > launchImage.showTime + 0.2f) 
                {   
                    m_CurIndex++;
                    
                    if (m_CurIndex >= launchImages.Length)
                    {
                        if (m_AnimEnd != null)
                            m_AnimEnd();
                
                        m_InAnim = false;
                        return;
                    }

                    LaunchImage nextImage = launchImages[m_CurIndex];
                    OnImageBeginShow(nextImage);
                    
                    m_LastBeginShowTime = Time.realtimeSinceStartup;
                    m_ImageHasShowedEnd = false;
                }
                else
                {
                    if (!m_ImageHasShowedEnd)
                    {
                        m_ImageHasShowedEnd = true;
                        
                        OnImageEndShow(launchImage);
                    }
                }
            }
        }
	}
}
