using System;
using UnityEngine;
using UnityEngine.UI;

public class NumController: MonoBehaviour
{
    public NumShow coinText;
    public NumShow diamondText;
    
    public void Init(int coin, int diamond)
    {
        if(coinText)
            coinText.num = coin;
        if(diamondText)
            diamondText.num = diamond;
    }

    private void Start()
    {
        GameUser.onUpdateCoin += UpdateCoinText;
        GameUser.onUpdateDiamond += UpdateDiamondText;

    }

    void UpdateCoinText(int coin)
    {
        this.coinText.num = coin;

    }
    
    
    void UpdateDiamondText(int diamond)
    {
        this.diamondText.num = diamond;


    }

    private void OnDestroy()
    {
        GameUser.onUpdateCoin -= UpdateCoinText;
        GameUser.onUpdateDiamond -= UpdateDiamondText;
    }
}