using System.Security.Cryptography;

public class GameSettingDisplayController:DisplayController
{
    private SettingUI m_Panel;
    
    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();

        if (m_Panel == null)
        {
            m_Panel = Instantiate(GameResourceManager.Load<SettingUI>(DisplayDefine.SettingPanel),transform);
            m_Panel.SetController(this);
        }
        m_Panel.Init();
    }

    public override void WillHideDisplay()
    {
        base.WillHideDisplay();
        
        m_Panel.FadeOut();
    }

    public override void OnDelete()
    {
        base.OnDelete();
        
        if(m_Panel)
            Destroy(m_Panel.gameObject);
        
        m_Panel = null;
    }
}

