using System;
using System.Collections.Generic;
using UnityEngine;

public class BattleUIDisplayController : DisplayController,IBattleMainUI
{
    public BattleSceneDisplayController battleScene => GetComponentInParent<BattleSceneDisplayController>();
    
    BattleMainUI m_Panel;
    public BattleMainUI panel => m_Panel;

    private BattleController m_BattleController;
    
    public void Init(BattleController battleController)
    {
        m_BattleController = battleController;
        
        if (m_Panel)
        {
            m_Panel.Init(m_BattleController);
        }  
    }
    
    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();

        if (m_Panel == null)
        {
            m_Panel = InitBattleUI();
        }  
        m_Panel.Init(m_BattleController);
    }

    BattleMainUI InitBattleUI()
    {
        BattleMainUI prefab = GameResourceManager.Load<BattleMainUI>(DisplayDefine.BattlePanel);
        var panel = GameObject.Instantiate<BattleMainUI>(prefab,transform);
        panel.uiListener = this;
       // panel.SetController(this);
       // panel.name = "战斗UI";
        return panel;
    }

    internal void GotoShop()
    {
        parentNav.LoadDisplay<ShopPanelDisplayController>();
    }

    internal void CsPlanel()
    {
        parentNav.LoadDisplay<CSPanelDisplayController>();
    }



    #region  UI implement

    public virtual void OnClickGoBack()
    {
        Game.Instance.LoadCurLevelGame();
    }

    public void OnClickRestart()
    {
        Game.Instance.LoadCurLevelGame();
    }

    public void OnClickLevelList()
    {
        GameDebug.Log("OnClickLevelList");

        var mapList = battleScene.battleSceneNav.LoadDisplay<MapListDisplayController>(null, false);
        MapListPanelData mapListPanelData = new MapListPanelData();
        
        mapListPanelData.itemDatas = new List<MapListItemData>(10);
        for (int i = 1; i <= 10; i++)
        {
            if (i <= Game.maxLevel)
            {
                mapListPanelData.itemDatas.Add(new MapListItemData()
                {
                    level = i,
                    active = true,
                    star = Game.Instance.user.GetStar(i)
                });
            }
            else
            {
                mapListPanelData.itemDatas.Add(new MapListItemData()
                {
                    level = i,
                    active = false,
                    star = Game.Instance.user.GetStar(i)
                });
            }
        }
        
        mapList.Init(mapListPanelData);
    }

    public void OnClickAdSkipLevel()
    {
#if UNITY_EDITOR
        OnWatchAdEnd();
        return;
#endif
        
        /*Game.Instance.audioManager.PauseMusic();

        Game.Instance.adController.ShowVideoAd(() =>
        {
            Game.Instance.audioManager.ResumeMusic();
            OnWatchAdEnd();
        }, (err) =>
        {
            Game.Instance.audioManager.ResumeMusic();
            GameDebug.LogError(err); Game.Instance.ShowNoticePanel(err);
        }, () =>
        {

            Game.Instance.audioManager.ResumeMusic();
        });*/
    }

    public void OnClickSetting()
    {
        parentNav.LoadDisplay<GameSettingDisplayController>(null,false);
    }

    void OnWatchAdEnd()
    {
        GameDebug.Log("跳到下一关");
       
        Game.Instance.NextLevel();   
        Game.Instance.LoadCurLevelGame();
    }

    #endregion

    
    public override void OnDelete()
    {
        base.OnDelete();

        if (m_Panel)
        {
            Destroy(m_Panel.gameObject);
        }
    }

    private void OnDestroy()
    {
        
    }

    public override void WillHideDisplay()
    {
        base.WillHideDisplay();

        if (m_Panel)
        {
            Destroy(m_Panel.gameObject);
           
        }
        GameDebug.Log("WillHideDisplay()方法调用");
    }
}