using System;
using System.Reflection;
using System.Runtime.CompilerServices;
using UnityEngine;

[AttributeUsage(AttributeTargets.Class)]
public class EntityTypeAttribute : Attribute
{
    public int entityType;

    public EntityTypeAttribute(int entityType)
    {
        this.entityType = entityType;
    }
}


public abstract class ViewEntity : MonoBehaviour
{
    public BattleController battleController => GetComponentInParent<BattleController>();

/*    /// <summary>
    /// 实体ID
    /// </summary>
    private int m_EntityId;
    public int entityId => m_EntityId;*/

    /// <summary>
    /// 实体类型
    /// </summary>
    public int entityType => GetType().GetCustomAttribute<EntityTypeAttribute>().entityType;

}
