﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class NumShowAudioPlay : IPlayLoopAudio
{

    public float maxPlayTime = 6;
    
    AudioClip m_ToPlayAudio;
    public AudioClip toPlayAudio
    {
        get
        {
            if(m_ToPlayAudio == null)
            {
                m_ToPlayAudio = GameResourceManager.LoadUIAudio(Audio.num_add);
            }

            return m_ToPlayAudio;
        }
        set { m_ToPlayAudio = value; }
    }

    
    public void PlayLoopAudio(AudioClip audio)
    {
        //GameDebug.Log("NumShowAudioPlay  PlayLoopAudio");
        AudioManager.instance.Play(audio, true);

        AudioManager.instance.StartCoroutine(GuaranteeStopLoopAudio(audio,maxPlayTime));
        
        /*Game.Instance.DelayAction(maxPlayTime,()
            =>
        {
           // GameDebug.LogShowy("保证音效关闭");
            StopLoopAudio(audio);
        });*/
    }

    IEnumerator GuaranteeStopLoopAudio(AudioClip audio,float time)
    {
        yield return  new WaitForSeconds(time);
        
        if (audio)
        {
            StopLoopAudio(audio);
        }

        // GameDebug.LogShowy("保证音效关闭");
    }
    
    
    public void StopLoopAudio(AudioClip audio)
    {
        //GameDebug.Log("NumShowAudioPlay  StopLoopAudio");
        AudioManager.instance.Stop(audio);
    }
}
