﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

[RequireComponent(typeof(Toggle))]
public class ListToggleItem : MonoBehaviour {

    [SerializeField]
    public int id;
    public string title {
        get
        {
            if (titleText == null) return "";
            else return titleText.text;
        }
    }
    public Text titleText;
    protected Toggle m_Toggle;
   // public Toggle toggle { get { return m_Toggle; } }
    protected Action<int> m_OnValueChange;

    /// <summary>
    /// 代码中设置isOn 不调用OnToggleValueChange
    /// </summary>
    bool InCodeSetIsOn = false;

    public bool isOn
    {
        get
        {
            if (m_Toggle == null) return false;
            return m_Toggle.isOn;
        }
        set
        {
            if (m_Toggle.isOn != value)
            {
                InCodeSetIsOn = true;

                if (m_Toggle == null) m_Toggle = GetComponent<Toggle>();
                if (m_Toggle != null)
                    m_Toggle.isOn = value;

                InCodeSetIsOn = false;
            }
        }
    }

    // Use this for initialization
    public virtual void Awake()
    {
        if (m_Toggle == null) m_Toggle = GetComponentInChildren<Toggle>();
        if (m_Toggle != null)
            m_Toggle.onValueChanged.AddListener(OnToggleValueChange);
    }

    private void OnDestroy()
    {
        m_OnValueChange = null;
    }

    public void Init(ToggleGroup _group, int id, Action<int> onValueChange)
    {
        Init(_group, id,"",onValueChange);
    }

    public void Init(ToggleGroup _group,int id,string titleName,Action<int>onValueChange)
    {
        this.id = id;

        if(titleText != null && !string.IsNullOrEmpty(titleName))
            titleText.text = titleName;

        if (m_Toggle == null) m_Toggle = GetComponentInChildren<Toggle>();
        if (m_Toggle != null) m_Toggle.group = _group;

        m_OnValueChange = onValueChange;
    }

    public void Init(Action<int> onValueChange)
    {
        m_OnValueChange = onValueChange;
    }

    public void Init(ToggleGroup _group, Action<int> onValueChange)
    {
        if (m_Toggle == null) m_Toggle = GetComponent<Toggle>();
        if (m_Toggle != null) m_Toggle.group = _group;
        m_OnValueChange = onValueChange;
    }

    public void SetInteractable(bool interact)
    {
        if(m_Toggle)
            m_Toggle.interactable = interact;
    }

    public void OnToggleValueChange(bool isOn)
    {
        _OnToggleValueChange(isOn);

        if (InCodeSetIsOn)
            return;

        //GameDebug.Log("OnToggleValueChange  :"+this.name+"  isOn:"+isOn);
        if (isOn)
        {
            if (m_OnValueChange != null)
                m_OnValueChange(id);
        }
    }

    protected virtual void _OnToggleValueChange(bool isOn)
    {

    }

}
