#if UNITY_EDITOR
using UnityEditor;
using UnityEngine;

public class ScriptableWizardEx
{
    public static void OpenWindow<T>() where T : ScriptableWizard
    {
        T[] wins = Resources.FindObjectsOfTypeAll<T>();
        if (wins.Length == 0)
        {
            ScriptableWizard.DisplayWizard<T>(typeof(T).Name);
        }
        else
        {
            wins[0].Focus();
        }
    }
}
#endif