﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEditor;
using UnityEngine.SceneManagement;
using UnityEditor.SceneManagement;
using System.IO;

public class BatchSetPrefab
{

    [MenuItem("Dyspace/Add Prefab Button SFX", false, 200)]
    static void AddPrefabButtonSFX()
    {
        AssetDatabase.StartAssetEditing();

        var guids = AssetDatabase.FindAssets(" t:GameObject", new string[] { "Assets/Resources/UI" });
        var cntButton = 0;
        var cntPrefab = 0;
        var cntToggle = 0;
        foreach (var g in guids)
        {
            string path = AssetDatabase.GUIDToAssetPath(g);
            GameObject prefab = AssetDatabase.LoadAssetAtPath(path, typeof(GameObject)) as GameObject;

            if (prefab == null)
                GameDebug.LogError("prefab == null" + path);

            var go = PrefabUtility.InstantiatePrefab(prefab) as GameObject;
            bool changed = false;

            var buttons = go.GetComponentsInChildren<Button>(true);
            foreach (var button in buttons)
            {
                if (button.GetComponent<ButtonSFX>() == null)
                {
                    Debug.Log("Add SFX " + path + button);
                    var sfx = button.gameObject.AddComponent<ButtonSFX>();
                    sfx.LoadAudio();
                    cntButton++;
                    changed = true;
                }
            }

            var toggles = go.GetComponentsInChildren<Toggle>(true);
            foreach (var toggle in toggles)
            {
                if (toggle.GetComponent<ButtonSFX>() == null)
                {
                    Debug.Log("Add SFX " + path + toggle);
                    var sfx = toggle.gameObject.AddComponent<ButtonSFX>();
                    sfx.LoadAudio();
                    cntToggle++;
                    changed = true;
                }
            }

            if (changed)
            {
                cntPrefab++;
                PrefabUtility.ReplacePrefab(go, PrefabUtility.GetCorrespondingObjectFromSource(go), ReplacePrefabOptions.ConnectToPrefab);
            }
            GameObject.DestroyImmediate(go);
        }

        AssetDatabase.StopAssetEditing();
        AssetDatabase.SaveAssets();

        Debug.Log("Changed: " + cntPrefab + " prefabs, " + cntButton + " buttons, " + cntToggle + " toggles.");
    }

    [MenuItem("Dyspace/Add Scene Button SFX", false, 201)]
    static void AddSceneButtonSFX()
    {
        var cntButton = 0;
        var cntToggle = 0;
        var canvas = GameObject.FindObjectOfType<Canvas>();
        var buttons = canvas.GetComponentsInChildren<Button>(true);
        foreach (var button in buttons)
        {
            if (button.GetComponent<ButtonSFX>() == null)
            {
                Debug.Log("Add SFX " + button);
                var sfx = button.gameObject.AddComponent<ButtonSFX>();
                sfx.LoadAudio();
                cntButton++;
            }
        }

        var toggles = canvas.GetComponentsInChildren<Toggle>(true);
        foreach (var toggle in toggles)
        {
            if (toggle.GetComponent<ButtonSFX>() == null)
            {
                Debug.Log("Add SFX " + toggle);
                var sfx = toggle.gameObject.AddComponent<ButtonSFX>();
                sfx.LoadAudio();
                cntToggle++;
            }
        }

        var scene = SceneManager.GetActiveScene();
        EditorSceneManager.MarkSceneDirty(scene);

        Debug.Log("Changed: " + cntButton + " buttons, " + cntToggle + " toggles.");
    }

    [MenuItem("Dyspace/Set Prefab Button Animation", false, 261)]
    static void SetPrefabButtonAnimation()
    {

        AssetDatabase.StartAssetEditing();
        var guids = AssetDatabase.FindAssets(" t:GameObject", new string[1] { "Assets/Resources/UI/Prefabs" });
        var cntButton = 0;
        var cntPrefab = 0;

        var animatorPath = "Assets/Resources/UI/Animations/Button/CommonButton.controller";

        var animatorController = AssetDatabase.LoadAssetAtPath<RuntimeAnimatorController>(animatorPath);
        if (animatorController == null)
        {
            Debug.Log("Cannot find " + animatorPath);
            return;
        }

        foreach (var g in guids)
        {
            string path = AssetDatabase.GUIDToAssetPath(g);
            GameObject prefab = AssetDatabase.LoadAssetAtPath(path, typeof(GameObject)) as GameObject;
            var go = PrefabUtility.InstantiatePrefab(prefab) as GameObject;
            bool changed = false;

            var buttons = go.GetComponentsInChildren<Button>(true);
            foreach (var button in buttons)
            {
                if (button.transition != Selectable.Transition.Animation)
                {
                    if (button.GetComponent<Animator>() != null)
                    {
                        Debug.LogWarning("button has animator already: " + path + " " + button.name);
                        continue;
                    }
                    button.transition = Selectable.Transition.Animation;
                    var ani = button.gameObject.AddComponent<Animator>();
                    ani.runtimeAnimatorController = animatorController;
                    cntButton++;
                    changed = true;
                }
                Debug.Log(path + " name:  " + button.name);
            }


            if (changed)
            {
                cntPrefab++;
                PrefabUtility.ReplacePrefab(go, PrefabUtility.GetCorrespondingObjectFromSource(go), ReplacePrefabOptions.ConnectToPrefab);
            }

            GameObject.DestroyImmediate(go);
        }

        AssetDatabase.StopAssetEditing();
        AssetDatabase.SaveAssets();

        //CommonFunctions.WriteTextToResourceFile(notfound, "languageNotfound.txt");

        Debug.Log("Changed: " + cntPrefab + " prefabs, " + cntButton + " text, ");
    }


    [MenuItem("Dyspace/Add Prefab TextFont", false, 200)]
    static void AddPrefabTextFont()
    {
        AssetDatabase.StartAssetEditing();

        var guids = AssetDatabase.FindAssets(" t:GameObject", new string[] { "Assets/Resources/UI" });
        int cntText = 0;
        foreach (var g in guids)
        {
            string path = AssetDatabase.GUIDToAssetPath(g);
            GameObject prefab = AssetDatabase.LoadAssetAtPath(path, typeof(GameObject)) as GameObject;

            if (prefab == null)
                GameDebug.LogError("prefab == null" + path);

            var go = PrefabUtility.InstantiatePrefab(prefab) as GameObject;
            bool changed = false;

            var texts = go.GetComponentsInChildren<Text>(true);
            foreach (var text in texts)
            {
                if (text.GetComponent<TextFont>() == null)
                {
                    Debug.Log("Add TextFont " + path + text);
                    var tf = text.gameObject.AddComponent<TextFont>();
                    cntText++;
                    changed = true;
                }
            }

            if (changed)
            {
                PrefabUtility.ReplacePrefab(go, PrefabUtility.GetCorrespondingObjectFromSource(go), ReplacePrefabOptions.ConnectToPrefab);
            }
            GameObject.DestroyImmediate(go);
        }

        AssetDatabase.StopAssetEditing();
        AssetDatabase.SaveAssets();

        Debug.Log("Changed:   cntText: " + cntText);
    }

    [MenuItem("Dyspace/Prefabs Selected Apply", false, 280)]
    static void SelectedPrefabsApply()
    {
        foreach (var go in Selection.gameObjects)
        {
            PrefabUtility.ReplacePrefab(go, PrefabUtility.GetCorrespondingObjectFromSource(go), ReplacePrefabOptions.ConnectToPrefab);
        }
    }

}

