﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DeviceInfo
{

   public static int GetScalerMatch()
    {
        float defaultValue = 1080f / 1920;
        float value = (float)Screen.width / Screen.height;
        if (defaultValue > value)
         {
            return 0;
        }
        else
        {
            return 1;
        }
    }


    /// <summary>
    ///  是否是iphoneX
    /// </summary>
    public static bool isiPhoneX
    {
        get
        {
            bool result = false;
            string modelStr = SystemInfo.deviceModel;
#if UNITY_IOS
           result = CheckIsIphoneX(modelStr);
#elif UNITY_EDITOR
            result = EditorCheckIsIphoneX();
#else
            result = false;
#endif             
            GameDebug.LogShowy("是否是iphoneX:" + result);
            return result;
        }
    }
    /// <summary>
    /// 是否是ipad
    /// </summary>
    public static bool isIpad
    {
        get
        {
            bool result = false;
            string modelStr = SystemInfo.deviceModel;
#if UNITY_IOS
           result =  CheckIsIpad(modelStr);
#elif UNITY_EDITOR
            result = EditorCheckIsIpad();
#else
            result = false;
#endif
            GameDebug.LogShowy("是否是ipad:" + result);
            return result;
        }
    }
   
    static bool EditorCheckIsIphoneX()
    {
        return Screen.width == 1125 && Screen.height == 2436;
    }

    static bool EditorCheckIsIpad()
    {
        return
            (Screen.width == 1536 && Screen.height == 2048) ||
            (Screen.width == 2048 && Screen.height == 2732) ||
            (Screen.width == 1668 && Screen.height == 2224) ||
            (Screen.width == 2048 && Screen.height == 1536);
    }

    static bool CheckIsIphoneX(string modelStr)
    {
        return
            modelStr.Equals("iPhone10,3") ||
            modelStr.Equals("iPhone10,6") ||
            modelStr.Equals("iPhone11,2") ||
            modelStr.Equals("iPhone11,4") ||
            modelStr.Equals("iPhone11,6") ||
            modelStr.Equals("iPhone11,8") ||
            modelStr.StartsWith("iPhone11") ||
            modelStr.StartsWith("iPhone12");
    }

    static bool CheckIsIpad(string modelStr)
    {
        return modelStr.StartsWith("iPad");           
    }

}
