﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class TransformAnim : AnimBase
{

    private void Awake()
    {

    }

    Vector3 LerpFunc(Vector3 a, Vector3 b, float value)
    {
        return a + (b - a) * value;
    }


    public Coroutine RotateTo(Transform trans, Vector3 targetRotation, float time, Action onEnd,bool ensureCallback = true,bool localRot = false)
    {
        return PlayAnim(targetRotation, time, LerpFunc,
            (rotation) =>
            {
                if (trans)
                {
                    if (localRot)
                    {
                        trans.localRotation = Quaternion.Euler(rotation);
                    }
                    else
                    {
                        trans.rotation = Quaternion.Euler(rotation);
                    }
                }
            },
            () =>
            {
                if (!trans)
                    return Vector3.zero;
                
                if (localRot)
                    return  trans.localRotation.eulerAngles;
                else
                    return trans.rotation.eulerAngles;
            }
           , onEnd,ensureCallback);
    }
    public Coroutine MoveTo(Transform trans, Vector3 targetPosition, float time, Action onEnd)
    {
        return MoveTo(trans, targetPosition, time, onEnd, false);
    }
    public Coroutine MoveTo(Transform trans, Vector3 targetPosition, float time, Action onEnd,bool localPos = false,bool ensureCallback = true)
    {
        return PlayAnim(targetPosition, time, LerpFunc,
            (pos) =>
            {
                if (trans)
                {
                    if (localPos)
                        trans.localPosition = pos;
                    else
                        trans.position = pos;
                }
            },
            () =>
            {
                if (!trans)
                    return Vector3.zero;

                if (localPos)
                    return trans.localPosition;
                else
                    return trans.position;
            }
           , onEnd,ensureCallback);
    }
    
    public Coroutine ScaleTo(Transform trans,Vector3 targetScale,float time, Action onEnd,bool ensureCallback = true)
    {
        return PlayAnim(targetScale, time, LerpFunc,
            (scale) =>
            {
                if(trans)
                    trans.localScale = scale;
            },
            () =>
            {
                if (trans == null)
                    return Vector3.one;

                return trans.localScale;
            }
           , onEnd,ensureCallback);
    }

}
