﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class RendererColorPingpongAnim : ColorPingPongAnim
{

    public Renderer render;

    public string colorPropertyName = "_Color";
    
    int ColorPropertyId = 0;
    

    // Use this for initialization
    protected override void Awake()
    {
        base.Awake();

        if (render == null)
        {
            render = GetComponentInChildren<Renderer>();
        }

        ColorPropertyId = Shader.PropertyToID(colorPropertyName);
        
    }

    private void OnEnable()
    {
        Play();
    }
    private void OnDisable()
    {
        Stop();
    }

    public override Action<Color> SetColorFunc()
    {
        Action<Color> setColorFunc = (color) =>
        {
            if (render)
                render.material.SetColor(colorPropertyName, color);
        };
        return setColorFunc;
    }

    public override Func<Color> GetColorFunc()
    {
        Func<Color> getColorFunc = () =>
        {
            if (render)
                return render.material.GetColor(colorPropertyName);

            return Color.white;
        };
        return getColorFunc;
    }


    [ContextMenu("Play")]
    public new void Play()
    {
        base.Play();
    }

    [ContextMenu("Stop")]
    public new void Stop()
    {
        base.Stop();
    }

}

