﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using UnityEngine.UI;

public class HomeLoadingAnim : DisplayControllerSwitchAnimation
{
    public GameObject parent;
//    public GameTips gameTips;

    public float fadeInTime = 0.2f;
    public float inLoadingTime = 0.2f;
    public float fadeOutTime = 0.4f;

    void  Awake()
    {
        if (parent)
            parent.gameObject.SetActive(false);

    }


    protected override  void OnDestroy()
    {
        m_InLoadingEnd = null;
    }
    protected  override  void PlayShowAnim(DisplayController dc,Action onAnimEnd)
    {
        /*if(gameTips)
            gameTips.RefreshTips();*/

        PlayAnim(() =>
        {

            if (onAnimEnd != null)
                onAnimEnd();
        });
    }

    private Action m_InLoadingEnd;
    protected override void PlayInLoadingAnim( Action onEnd)
    {        
        m_InLoadingEnd = onEnd;

        PlayInLoading(onEnd);
    }

    protected override void PlayHideAnim(Action onAnimEnd)
    {
        Hide(() =>
        {
            if (parent)
                parent.gameObject.SetActive(false);

            if (onAnimEnd != null)
                onAnimEnd();
        });
    }



    /// <summary>
    /// 播放切换场景过渡动画
    /// </summary>
    /// <param name="onFinished"></param>
    public void PlayAnim(Action onFinished)
    {
        //if (isFadingToBlack)
        //    return;
        
        GameDebug.LogError("HomeLoading PlayAnim!!");
        
        if (parent)
            parent.gameObject.SetActive(true);
        
        delayAction.DelayDoAction(this.fadeInTime,onFinished);
    }

    private DelayAction m_DelayAction;

    public DelayAction delayAction
    {
        get
        {
            if (m_DelayAction == null)
                m_DelayAction = gameObject.AddComponent<DelayAction>();
            return m_DelayAction;
            
        }
    }

    void PlayInLoading(Action onEnd)
    {
       Invoke("OnInLoadingEnd",inLoadingTime);
    }

    void OnInLoadingEnd()
    {
        if (m_InLoadingEnd != null)
            m_InLoadingEnd();
    }
    
    public void Hide(Action onFinished)
    {
        delayAction.DelayDoAction(this.fadeOutTime,onFinished);
    }
    

    [ContextMenu("TestPlayFadeInAnim")]
    void TestPlayFadeInAnim()
    {
        PlayAnim(null);
    }
   
    [ContextMenu("TestPlayFadeOutAnim")]
    void TestPlayFadeOutAnim()
    {
        Hide(()=>parent.gameObject.SetActive(false));
    }

    void Update()
    {
        
    }


}
