using System.Collections.Generic;

[System.Serializable]
public class EntityCollection
{
    public EntityCollection()
    {
        
    }
    private List<ViewEntity> m_Entities = new List<ViewEntity>();
    
    public int entitisCount => m_Entities != null ? m_Entities.Count : 0;

    public T GetEntity<T>(int entityId) where T : ViewEntity
    {
        if (entityId >= 0 && entityId < m_Entities.Count)
        {
            return m_Entities[entityId] as T;
        }
        else
        {
            GameDebug.LogError($"entityId:{entityId}  m_Entities.Count:{m_Entities.Count}");
            return null;
        }
    }

    /// <summary>
    /// 添加实体
    /// </summary>
    /// <param name="entity"></param>
    public void AddEntity(ViewEntity entity)
    {
        if (entity)
        {
            //entity.SetEntityId(GetCurEntityId());

            m_Entities.Add(entity);
        }
    }

    int GetCurEntityId()
    {
        return m_Entities.Count;
    }

}