﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public abstract class BattleWidgetInfo : AlphaShowHideUI
{
   
    // Use this for initialization
    protected virtual void Start () {
	}

    protected Transform m_Reference;
    protected Func<Vector3, Vector3, Vector3> m_WorldToUIPosFunc;
    public virtual void Init(Transform refer, Func<Vector3, Vector3, Vector3> worldToUIPosFunc)
    {
        m_Reference = refer;
        m_WorldToUIPosFunc = worldToUIPosFunc;
        
        var rect = GetComponent<RectTransform>();
        SetPosition(rect, refer.transform.position);
    }

    protected void SetPosition(RectTransform rect, Vector3 uipos)
    {
        rect.SetUIPosition(uipos);
        //rect.transform.position = uipos;
        //var ap = rect.anchoredPosition3D;
        //ap.z = 10;
        //rect.anchoredPosition3D = ap;
    }

    // Update is called once per frame
    protected virtual void Update () {



	}
}
