﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class TipsInfo : AlphaShowHideUI {

    public Text contentText;
    public string content { get { return this.contentText.text; } }
    public Image bg;
    
    protected override void Awake()
    {
        base.Awake();

        if (contentText == null)
            contentText = GetComponentInChildren<Text>();
    }

    // Use this for initialization
    void Start () {
		
	}
    public void Init(string content)
    {
        contentText.text = content;
        StartCoroutine(RefreshSize());
    }
    public void Init(string content,Vector2 anchoredPos)
    {
        contentText.text = content;
        GetComponent<RectTransform>().anchoredPosition = anchoredPos;

        StartCoroutine(RefreshSize());
    }
	
    IEnumerator RefreshSize()
    {
        yield return 0;

       var ver = GetComponentInChildren<VerticalLayoutGroup>();
       if(ver)
            ver.enabled = false;
        if (ver)
            ver.enabled = true;
    }
        
    
}
