﻿#if UNITY_EDITOR
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class EditorMeshSaver
{	
	[MenuItem("Tools/SaveMesh")]
	static void MenuSaveMesh ()
	{
		Transform selected = Selection.activeTransform;
		if (selected == null)
		{
			GameDebug.Log("no selected");
			return;
		}

		MeshFilter filter = selected.GetComponent<MeshFilter>();
		if (filter == null)
		{
			GameDebug.Log("no MeshFilter");
			return;
		}

		SaveMesh(filter);
	}

	[MenuItem("Tools/SaveMesh_Copy")]
	static void MenuSaveMesh2 ()
	{
		Transform selected = Selection.activeTransform;
		if (selected == null)
		{
			GameDebug.Log("no selected");
			return;
		}

		MeshFilter filter = selected.GetComponent<MeshFilter>();
		if (filter == null)
		{
			GameDebug.Log("no MeshFilter");
			return;
		}

		SaveMesh2(filter);
	}


	static void SaveMesh (MeshFilter meshFilter)
	{
		Mesh mesh = meshFilter.sharedMesh;

		string savePath = "Assets/newMesh.prefab";
		UnityEditor.AssetDatabase.CreateAsset(mesh, savePath);
		GameDebug.Log("save mesh done");
	}

	static void SaveMesh2 (MeshFilter meshFilter)
	{
		Mesh mesh = meshFilter.sharedMesh;

		mesh = CopyMesh(mesh);

		string savePath = "Assets/newMesh.prefab";
		UnityEditor.AssetDatabase.CreateAsset(mesh, savePath);
		GameDebug.Log("save mesh done");
	}

	static Mesh CopyMesh (Mesh mesh)
	{
		Mesh newMesh = new Mesh();
		newMesh.vertices = mesh.vertices;
		newMesh.uv = mesh.uv;
		newMesh.uv2 = mesh.uv2;
		newMesh.triangles = mesh.triangles;
		newMesh.RecalculateNormals();
		newMesh.RecalculateTangents();
		newMesh.RecalculateBounds();
		return newMesh;
	}
}

#endif
