﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class UITextPingPongAnim : ColorPingPongAnim
{

    public Text m_Text;

    public bool selfStart = true;

    // Use this for initialization
    void Start()
    {
        if (m_Text == null)
            m_Text = GetComponentInChildren<Text>();

    }

    private void OnEnable()
    {
        if (selfStart)
            Play();
    }
    private void OnDisable()
    {
        Stop();
    }

    public override Action<Color> SetColorFunc()
    {
        Action<Color> p = (color) =>
        {
            if (m_Text)
                m_Text.color = color;
        };
        return p;
    }

    public override Func<Color> GetColorFunc()
    {
        Func<Color> f = () =>
        {
            if (m_Text)
                return m_Text.color;
            else
                return Color.white;
        };
        return f;
    }

}
