﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class RendererAnim : AnimBase
{

    //float FloatLerpFunc(float a, float b, float value)
    //{
    //    return Mathf.Lerp(a, b, value);
    //}

    //public void AlphaAnim(Renderer renderer, int propertyID,float targetAlpha,float time, Action onEnd)
    //{
    //    StartCoroutine(PlayAnim<float>(targetAlpha, time, FloatLerpFunc,
    //      (alpha) =>
    //      {
    //          var color = renderer.material.GetColor(propertyID);
    //          color.a = alpha;
    //          renderer.material.SetColor(propertyID, color);
    //      },
    //      () =>
    //      {
    //          return renderer.material.GetColor(propertyID).a;
    //      }
    //     , onEnd));
    //}
    
    Color ColorLerpFunc(Color a, Color b, float value)
    {
        return Color.Lerp(a, b, value);
    }

    public Coroutine ColorAnim(Renderer renderer, int propertyID, Color targetColor, float time, Action onEnd,bool ensureCallback = true)
    {
        return PlayAnim<Color>(targetColor, time, ColorLerpFunc,
          (color) =>
          {
              if(renderer)
                renderer.material.SetColor(propertyID, color);
          },
          () =>
          {
              if(!renderer)
                 return Color.white;

              if (renderer.material.HasProperty(propertyID))
                return renderer.material.GetColor(propertyID);

              return Color.white;
          }
         , onEnd,ensureCallback);
    }
    public Coroutine ColorAnim(Material material, int propertyID, Color targetColor, float time, Action onEnd,bool ensureCallback = true)
    {
        return PlayAnim<Color>(targetColor, time, ColorLerpFunc,
          (color) =>
          {
              if (material)
                  material.SetColor(propertyID, color);
          },
          () =>
          {
              if (!material)
                  return Color.white;

              if (material.HasProperty(propertyID))
                  return material.GetColor(propertyID);

              return Color.white;
          }
         , onEnd,ensureCallback);
    }


    public Coroutine ColorAnim(Action<Color>setColorFunc,Func<Color> getColorFunc,  Color targetColor, float time, Action onEnd,bool ensureCallback = true)
    {
        return PlayAnim<Color>(targetColor, time, ColorLerpFunc,
          (color) =>
          {
              if(setColorFunc != null)
                setColorFunc(color);
          },
          () =>
          {
              if (getColorFunc != null)
                  return getColorFunc();
              else
                  return Color.white;
          }
         , onEnd,ensureCallback);
    }


    public void StopAnim()
    {
        StopAllCoroutines();
    }

}
