using UnityEngine;

public static class FloatExt
{
    public static bool EqualWith(this float f1, float f2)
    {
        return FloatCompare(f1, f2,6);
    }
    
    /// <summary>
    /// 浮点数比较
    /// </summary>
    /// <param name="f1"></param>
    /// <param name="f2"></param>
    /// <param name="round">精确到小数点后多少位</param>
    /// <returns></returns>
    public  static bool FloatCompare(float f1, float f2,int round)
    {
        float  f1P = f1 * Mathf.Pow(10, round);
        float  f2P = f2 * Mathf.Pow(10, round);
        int f1pInt = (int)(f1P + 0.5f);
        int f2pInt = (int)(f2P + 0.5f);
        return f1pInt == f2pInt;
    }

    /// <summary>
    /// 浮点数取粗略值
    /// </summary>
    /// <param name="f"></param>
    /// <param name="roundCount"></param>
    /// <returns></returns>
    public static float Round(float f, int round)
    {
        float pow = Mathf.Pow(10, round);
        float f1P = f * pow;
        int f1pInt = (int)(f1P + 0.5f);
        return f1pInt / pow;
    }
}