﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DisplayController : MonoBehaviour
{
    /// <summary>
    /// 用于识别同类名的不用界面
    /// </summary>
    string m_DisplayId;
    public string displayId
    {
        get { return m_DisplayId; }
        set { m_DisplayId = value; }
    }

    public bool deletePreUI = true;
         

    /// <summary>
    /// 控制Nav （父节点）
    /// </summary>
    public DisplayControllerNav parentNav
    {
        get
        {
            return this.GetComponentInParent<DisplayControllerNav>();
        }
    }

    public void RemoveFromNav()
    {
        parentNav.Remove(this);
    }

    /// <summary>
    /// 淡入动画播放完调用，再次激活时会再次调用（最先）
    /// </summary>
    public virtual void WillLoadDisplay()
    {

        //Debug.Log("WillLoadDisplay: " + this.name);
    }

    /// <summary>
    /// 淡出动画播放前就调用（最先）
    /// </summary>
    public virtual void WillHideDisplay()
    {
        //  Debug.Log("WillHideDisplay: "+this.name);
    }

    /// <summary>
    /// 淡入动画播放完及WillLoadDisplay初始化完才调用
    /// </summary>
    public virtual void DidLoadDisplay()
    {

    }

    public virtual void OnDidLoadDisplay(System.Action initEnd)
    {
        try
        {
            DidLoadDisplay();
        }
        catch { }
        
        if (initEnd != null)
            initEnd();

    }
    
    /// <summary>
    /// 淡出动画播放前调用，此方法结束后才播放淡出动画
    /// </summary>
    public virtual void DidHideDisplay()
    {

    }

    public void OnDidHideDisplay(System.Action onEnd)
    {
        try
        {
            DidHideDisplay();
        }
        catch(Exception e) { Debug.LogError(e);}

        if (onEnd != null)
            onEnd();
    }


    /// <summary>
    /// 淡出动画播放完才调用（最后）
    /// </summary>
    /// <param name="initEnd"></param>
    public virtual void OnLoadedEndDisplay()
    {

    }
    

    /// <summary>
    /// 淡出动画播放完才调用（最后）
    /// </summary>
    public virtual void OnDelete()
    {

    }


    /// <summary>
    /// 延迟调用OnDelete
    /// </summary>
    public bool delayDelete;

    public float delayDeleteTime = 0.5f;
    float timer = 0;
    void Update()
    {
        if (delayDelete)
        {
            timer += Time.deltaTime;
            if(timer > delayDeleteTime)
            {
                timer = 0;
                if (delayDelete)
                {
                    GameDebug.Log($"{this.name} OnDelete");
                    delayDelete = false;
                    OnDelete();
                }
            }
        }

        _Update();
    }
    protected virtual void _Update(){}
    
}

