﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.IO;

public static class Audio
{
    public static string sound_power_up = "power_up";

    //UI Sound uiSoundPath = "UI/Sound";
    public const string btn_common = "sound_click_ui";
    public const string btn_big = "sound_button_click_ui";
    public const string MUS_SYS_shield = "MUS_SYS_shield";
    public const string floatTips = "sfx_button_030";
    public const string num_add = "sound_grow_ui";

    public const string me_win = "me_win";
    public const string me_lose = "me_lose";
    
    /// BattleSceneSound   battleSceneSoundPath = "Battle/SceneSound";
    public const string sound_coin = "sound_coin";
    public const string sound_swamp = "sound_swamp";
    public const string sound_sand = "sound_sand";
    public const string sound_water = "sound_water";
    public const string sound_blocks = "sound_blocks";
    public const string sound_jump = "sound_jump";
}



public class AudioManager : MonoBehaviour, IAudioSetting
{
    private static AudioManager _instance;
    public static AudioManager instance
    {
        get
        {
            if (_instance == null)
            {
                _instance = FindObjectOfType<AudioManager>();
                
                if (_instance == null)
                {
                    _instance = new GameObject("AudioManager").AddComponent<AudioManager>();
                }
            }
            return _instance;
            
        }
    }
    
    bool MusicOn = true;
    bool SoundOn = true;

    public void SetMusic(bool isOn)
    {
        if(MusicOn != isOn)
        {
            if (isOn)
            {
                if (musicSource)
                    musicSource.Play();
            }
            else
                StopAllMusic();
        }
        MusicOn = isOn;
    }
    public void SetSound(bool isOn)
    {
        SoundOn = isOn;
    }

    void Awake()
    {
        //MusicOn = Game.Instance.gameSetting.bgMusic;
        //SoundOn = Game.Instance.gameSetting.soundEffect;

        pool = gameObject.AddComponent<Pool>();
        GameObject temp = new GameObject("Audio Source").AddComponent<AudioSource>().gameObject;
        temp.transform.SetParent(pool.transform);
        pool.template = temp;
    }

    public Pool pool;

    List<AudioSource> activeList = new List<AudioSource>();

    AudioSource musicSource;


    void LateUpdate()
    {
        List<AudioSource> toBeRemove = new List<AudioSource>();
        foreach (var audioSource in activeList)
        {
            if (!audioSource.isPlaying)
            {
                toBeRemove.Add(audioSource);
            }
            else
            {
               // stopCount[audioSource] = 0;
            }
        }

        foreach (var audioSource in toBeRemove)
        {
            Stop(audioSource);
        }
    }
    public void PlayUISound(string audio)
    {
        GameDebug.Log("PlayUISound:" + audio);
        PlayUISound(audio, false);
    }

    public void PlayUISound(string audio,bool loop)
    {
        Play(GameResourceManager.LoadUIAudio(audio),transform.position, loop,null,false);
    }

    public void PlayBattleSound(string audio,Vector3 position)
    {
        //GameDebug.Log("PlayBattleSound:" + audio);
        Play(GameResourceManager.LoadBattleSceneAudio(audio), position, false, null, false);
    }
    


    public void Play(AudioClip clip)
    {
        Play(clip,transform.position,false,null,false);
    }

    public void Play(AudioClip clip, bool loop)
    {
        if (clip == null) return;

        Play(clip, transform.position, loop, null, false);
    }

    public AudioSource Play(AudioClip clip,Vector3 pos, bool loop , AudioSource source, bool isMusic)
    {
        if (clip == null)
        {
            Debug.LogError("要播放的音效为空！");
            return null;
        }
        //DYDebug.Log("播放音效1" + clip.ToString());

        if (isMusic)
        {
            if (!MusicOn)
            {
                return null;
            }
        }
        else
        {
            if (!SoundOn)
            {
                return null;
            }

        }

        AudioSource audioSource;
        if (source == null)
        {
            var go = pool.Gen();
            audioSource = go.GetComponent<AudioSource>();
        }
        else
        {
            audioSource = source;
        }
        audioSource.transform.position = pos;

        // stopCount[audioSource] = 0;

        if (audioSource.clip != clip || !loop || !audioSource.isPlaying)
        {
            audioSource.clip = clip;
            audioSource.loop = loop;
            audioSource.gameObject.SetActive(true);
            audioSource.Play();
        }


        if (source == null)
        {
            activeList.Add(audioSource);

            if (isMusic)
            {
                this.musicSource = audioSource;
            }
        }
        return audioSource;
    }

    public void Stop(AudioClip clip)
    {
        if (clip == null) return;

        //string audioName = System.IO.Path.GetFileNameWithoutExtension(audioPath);
        AudioSource audioSource = this.activeList.Find(e =>e == null ?false: e.clip.Equals(clip));
        //GameDebug.Log("stop audio :" + clip.name);
        if (audioSource != null)
        {
            Stop(audioSource);
        }
        else
        {
            //GameDebug.Log("not find  :" + clip.name);
        }
    }

    public void Stop(AudioSource audioSource)
    {
        audioSource.Stop();

        if (musicSource != audioSource)
        {
            activeList.Remove(audioSource);
            pool.Recycle(audioSource.gameObject);
        }

    }

    public void StopAllMusic()
    {
        if(musicSource)
            musicSource.Stop();
    }

    public void PauseMusic()
    {
        if (!MusicOn)
            return;

        if (musicSource)
            musicSource.Pause();
    }

    public void ResumeMusic()
    {
        if (!MusicOn)
            return;

        if (musicSource)
            musicSource.Play();
    }

    public void SetMusicSpeed(float speed)
    {
        if (musicSource)
            this.musicSource.pitch = speed;
    }

}
