using System;
#if ByteDanceAd
public class ByteDanceAdController : IAdController
{
    public ByteDanceAdController()
    {

        var ad = UnionAdManager.instance;

    }
    
    public void LoadBanner()
    {

          //不显示Banner
                return;
        GameDebug.Log($"UnionAdManager -> LoadExpressBannerAd");
        try
        {
            UnionAdManager.instance.LoadExpressBannerAd();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }

    }

    public void ShowBanner()
    {

        //不显示Banner
        return;
        GameDebug.Log($"UnionAdManager -> ShowBanner");

        try
        {
            UnionAdManager.instance.ShowExpressBannerAd();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }

        
    }

    public void CloseBanner()
    {

        //不显示Banner
        return;
        GameDebug.Log($"UnionAdManager -> CloseBanner");
        try
        {
            UnionAdManager.instance.CloseBanner();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }
        LoadBanner();

    }

    public void LoadRectangleAd()
    {

        //不显示Banner
        return;
        GameDebug.Log($"UnionAdManager -> LoadRectangleAd");
        try
        {
            UnionAdManager.instance.LoadExpressRectangleAd();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }

    }

    public void ShowRectangleAd()
    {

        //不显示Banner
        return;
        GameDebug.Log($"UnionAdManager -> ShowRectangleAd");
        try
        {  
            UnionAdManager.instance.ShowExpressRectangleAd();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }

        //GameDebug.Log($"UnionAdManager -> ShowRectangleAd");
        
    }

    public void CloseRectangleAd()
    {

        //不显示Banner
        return;
        try
        {
            UnionAdManager.instance.CloseRectangelAd();
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
        }
        UnionAdManager.instance.Invoke(nameof(UnionAdManager.LoadExpressRectangleAd),0.2f);
        GameDebug.Log($"UnionAdManager -> CloseRectangleAd");
        
        //UnionAdManager.instance.LoadExpressInterstitialAd();

    }

    private float m_LastShowFullScreenAdTime;
    
    public void LoadInterstitialAd()
    {

        GameDebug.Log($"UnionAdManager -> LoadInterstitialAd");
        UnionAdManager.instance.LoadFullScreenVideoAd();

    }

    public void ShowInterstitialAd(Action onSuc,Action<string> onFail,Action<string> onClose)
    {
      

        if (m_LastShowFullScreenAdTime > 0 && UnityEngine.Time.realtimeSinceStartup - m_LastShowFullScreenAdTime <= 180)
        {
            GameDebug.LogError("全屏广告最多3分钟显示一次");
            onFail?.Invoke("全屏广告最多3分钟显示一次");
            return;
        }

        m_LastShowFullScreenAdTime = UnityEngine.Time.realtimeSinceStartup;
        
        GameDebug.Log($"UnionAdManager -> ShowInterstitialAd");
        UnionAdManager.instance.ShowFullScreenVideoAd(onSuc,onFail);

    }

    public void CloseInterstitalAd()
    {

        GameDebug.Log($"UnionAdManager -> CloseInterstitalAd");
        //UnionAdManager.instance.CloseFullScreenVideo();

    }

    public bool isVideoReady()
    {
        return  UnionAdManager.instance.isVideoReady;
    }

    public void LoadVideoAd()
    {

        GameDebug.Log($"UnionAdManager -> LoadVideoAd");
        UnionAdManager.instance.LoadRewardAd();

    }

    public void ShowVideoAd(Action onSuc, Action<string> onFail, Action onClose)
    {

        GameDebug.Log($"UnionAdManager -> ShowVideoAd");
        UnionAdManager.instance.ShowRewardAd(onSuc,()=>
        {
            GameDebug.LogError("视频播放失败");
            LoadVideoAd();
            onFail?.Invoke("");
        });

    }
}
#endif