﻿using System.Collections;
using System.Net.Mime;
using UnityEngine;
using UnityEngine.Serialization;
using UnityEngine.UI;
public interface IResultSceneUI
{
    void OnClickAgain();
    void OnClickSkip();
    void OnClickAdMulti();
    void OnClickNext();
    void OnProgressAnimEnd();
    void OnClickGoBack();
}


public class ResultSceneUI : MonoBehaviour
{
    public IResultSceneUI uiListener;

    public Text addScoreText;
    public Text levelText;

    public GameObject winGo;
    public GameObject loseGo;

    public GameObject againBtn;
    public GameObject adMultiBtn;
    public GameObject nextBtn;
    
    public Transform starParent;

    public GameObject winFX;

    public RuntimeAnimatorController loseAnimCtrl;

    public Star starPref;
    
    // Start is called before the first frame update
    void Awake()
    {
        if(winGo)
            winGo.SetActive(true);
        if(loseGo)
            loseGo.SetActive(true);
        
        if(starPref)
            starPref.gameObject.SetActive(false);
    }


    public void Init(PersonalResultPanelData data)
    {
        if (data.win)
        {
            if(winGo)
                winGo.gameObject.SetActive(true);
            if(loseGo)
                loseGo.gameObject.SetActive(false);
            
            if(winFX)
                winFX.SetActive(true);
            if(adMultiBtn)
                adMultiBtn.SetActive(false);
            if(nextBtn)
                nextBtn.SetActive(false);

            for (int i = 0; i < 3; i++)
            {
                var newItem = Instantiate(starPref, this.starParent);
                
                newItem.gameObject.SetActive(true);
                newItem.Init(i<data.star);
            }
            
            //rewardController.gameObject.SetActive(true);
            //rewardController.Init(data.level,OnProgressAnimEnd);
        }
        else
        {
            //loseBtn.ExecuteClick();
            if(levelText)
                levelText.text = $"level{data.level}" ;
            if(winGo)
                winGo.gameObject.SetActive(false);
            if(loseGo)
                loseGo.gameObject.SetActive(true);
          
            if(winFX)
                winFX.SetActive(false);

            //InitRoleModel(data.role.roleId);
        }

        SetAddScore( data.coin);
    }

    /*
    void OnProgressAnimEnd()
    {
        uiListener?.OnProgressAnimEnd();

        DelayAction.DelayDo(0.5f,(() =>
        {
            adMultiBtn.SetActive(true);
            nextBtn.SetActive(true);
        }));
    }
    */

    public void SetAddScore(int coin)
    {
        if (addScoreText)
            addScoreText.text = coin.ToString();
    }

    public void HideAdMultiBtn()
    {
        if(this.adMultiBtn)
            adMultiBtn.SetActive(false);
    }
    
    /*void InitRoleModel(int roleId)
    {
        ClearModel();
        
        var rolePref = GameResourceManager.LoadRolePerformancePrefab(roleId);

        var role = Instantiate(rolePref, this.modelParent);

        var trans = role.transform.GetComponentsInChildren<Transform>();
        trans.ForEach(e=>e.gameObject.layer = LayerMask.NameToLayer("UI"));

        Animator animator = role.GetComponentInChildren<Animator>();
        if (animator)
            animator.runtimeAnimatorController = this.loseAnimCtrl;
        
        role.transform.localPosition = Vector3.zero;
    }
    
    void ClearModel()
    {
        for (int i = 0; i < modelParent.childCount; i++)
        {
            DestroyImmediate(modelParent.GetChild(i).gameObject);
        }

    }*/
    

    public void OnClickAnotherGame()
    {
        uiListener?.OnClickAgain();
    }

    public void OnClickSkip()
    {
        uiListener?.OnClickSkip();
    }
    
    public void OnClickAdMulti()
    {
        uiListener?.OnClickAdMulti();
    }
    public void OnClicNext()
    {
        uiListener?.OnClickNext();
    }

    public void OnClickGoBack()
    {
        uiListener?.OnClickGoBack();
    }

    public void Release()
    {
        
    }
}
