﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using DG.Tweening;
using DG.Tweening.Core;
public enum MoveType
{
    MoveType1=1,
    MoveType2=2,
    MoveType3=3
}
public class PlayerMove : MonoBehaviour
{
    [Header("控制移动")]
    [Tooltip("控制向前的速度。")]
    public float VSpeed = 40.0f;
    public int SpeedLevel = 1;
    [Tooltip("控制左右移动的速度。")]
    public float HSpeed = 10.0f;
    
    [Tooltip("主角移动方式")]
    public MoveType moveType= MoveType.MoveType3;
    [Header("地面检测")]
    public Transform ray1Pos;
    public Transform ray2Pos;
    private RaycastHit RHit;
    private CharacterController characterController;


    private bool m_bIsCanMove = true;//是否能开车
    private MeshCollider[] m_targetTrans;//所有目标
    private MeshCollider m_curTargetTrans;//当前抓的目标
 //   private Rigidbody m_rigidBody;//自身刚体
    private Dictionary<MeshCollider, bool> m_dicBox = new Dictionary<MeshCollider, bool>();

    private bool m_bControlStartMove = false;
    private RectTransform m_thumbRT;//摇杆
    private Dictionary<Rigidbody, bool> m_dicRigidDic = new Dictionary<Rigidbody, bool>();
    private bool isGround1 = true;
    private bool isGround2 = true;
    private bool isAddSpeed = true;
    private float timer = 0.0f;
    //眩晕时长
    private float timerVertigo = 0.0f;



    // Start is called before the first frame update
    void Start()
    {
        characterController = GetComponent<CharacterController>();
        BattleCtrl.instance.turnDir += TurnDir;
        //m_rigidBody = GetComponent<Rigidbody>();
        


        GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        m_thumbRT = GameServices.inputService.joyStick.thumb;

        
    }

    private void OnTriggerEnter(Collider other)
    {
        //print("OnTriggerEnter:"+other.name);
        if (other.tag == "Gold")
        {
            SpeedLevel += 1;
            BattleCtrl.instance.Score++;
            BattleCtrl.instance.updateScore?.Invoke();
            Destroy(other.gameObject);
        }
        else if (other.tag== "Prickle")
        {
            if (this.SpeedLevel > 1)
            {
                this.SpeedLevel--;
            }
        }
        //else if (other.tag == "Prop" && DoRanking._instance.rankingList[2]!=gameObject) //自己不是最前面的人。
        //{
        //    print("出现怪。目标："+DoRanking._instance.rankingList[2].name);
        //    Destroy(other.gameObject);
        //}


    }


    void RotateInvoke()
    {
        CancelRotateInvoke();
        InvokeRepeating("RotateTarget", 0.5f, 0.5f);
    }
    //取消invoke
    void CancelRotateInvoke()
    {
        if (IsInvoking("RotateTarget"))
        {
            CancelInvoke("RotateTarget");
        }
    }
    void OnTouchStart()
    {
        print("触碰开始。");
        float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;//控制摇杆的位置。
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
        BattleCtrl.instance.battleUI.ShowJoystick();
    }
    // 抬起回调
    void OnTouchUp()
    {
        print("触碰结束。");
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //m_bControlPlay = true;

       

        BattleCtrl.instance.battleUI.SetSymbolPos(0, 0);

        //----------摇杆操作
        BattleCtrl.instance.battleUI.HideJoystick();
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
    }
    
    void CancelDelayMoveHandle()
    {
        if (IsInvoking("DelayMoveHandle"))
        {
            CancelInvoke("DelayMoveHandle");
        }
    }


    private void FixedUpdate()
    {
        //print("游戏是否开始："+ BattleCtrl.instance.isStartBattle);
        //print("游戏是否结束："+ BattleCtrl.instance.isEndBattle);
        
        if (!BattleCtrl.instance.isStartBattle)
        {
            isAddSpeed = true;
            return;
        }
        if (BattleCtrl.instance.isEndBattle)
        {
            isAddSpeed = true;
            return;
        }


        //射线检测。
        //Debug.DrawRay(transform.position, Vector3.down * 10f, Color.red);
        RaycastHit hit;
        //isGround = Physics.Raycast(transform.position, -Vector3.up, out hit,3.0f);// 可控制投射距离bool grounded = Physics.Raycast(transform.position, -Vector3.up, out hit,100.0);
        isGround1 = Physics.Raycast(ray1Pos.position, -Vector3.up, out hit, 3.0f);
        if (hit.collider!=null)
        {
            RHit = hit;
        }
        isGround2 = Physics.Raycast(ray2Pos.position, -Vector3.up, out hit, 3.0f);
        if (hit.collider != null&& RHit.collider!=null)
        {
            RHit = hit;
        }
        if (RHit.collider != null)
        {
            //print("正向：" + RHit.collider.gameObject.transform.forward.ToString());
        }

        if (isGround1||isGround2)
        {
            //在跑道上。
            timer = 0.0f;

        }
        else 
        {
            print("跑出跑道。");
            //m_rigidBody.constraints = RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationY | RigidbodyConstraints.FreezeRotationZ;
            timer += Time.deltaTime;  //用来记时，1.5秒后如果player的y值小于-1.0f就判定游戏失败。
            if (timer >= 1.5f && transform.position.y <= -1.0f)
            {
                //不在跑道上，并且y<-1.0f。游戏失败
                BattleCtrl.instance.OnBattleFail();
            }
        }

        if (m_bIsCanMove  && !BattleCtrl.instance.isEndBattle)
        {
            if (timerVertigo <= 0)
            {
                timerVertigo = 0;
                //移动控制。
                UpdateJoystick();
            }
            else
            {
                //眩晕
                timerVertigo -= Time.deltaTime;
            }
            
        }

        
    }

    //摇杆控制
    void UpdateJoystick()
    {
        //print("摇杆控制左右");
        switch (moveType)
        {
            case MoveType.MoveType1:
                MoveType1(); //阻尼的形式
                break;
            case MoveType.MoveType2:
                MoveType2(); //乱飘的形式
                break;
            case MoveType.MoveType3:
                MoveType3();   //比较生硬的形式
                break;
            default:
                MoveType3();   //比较生硬的形式
                break;

        }
        //MoveType1(); //阻尼的形式
        //MoveType2(); //乱飘的形式
        //MoveType3();   //比较生硬的形式
    }

    public void MoveType1()
    {
        //1、rigibody的形式左右移动。
        float angle = 90 * 0.01f * GameServices.inputService.joyStick.axisX.axisValue;
        if (angle != 0)
        {
            //拖动摇杆改变速度方向
            //m_rigidBody.velocity = Quaternion.Euler(0, angle, 0) * m_rigidBody.velocity;
        }
        else
        {
            //松开摇杆恢复速度方向。
            if (isGround1 || isGround2)
            {
                //在地面上保持一定的速度。
                //m_rigidBody.velocity = Vector3.Lerp(m_rigidBody.velocity, transform.forward * VSpeed, 5 * Time.deltaTime);
                //m_rigidBody.velocity = transform.forward * VSpeed;
            }

        }
    }

    public void MoveType2()
    {
        if(isGround1|| isGround2)
        {
            //在地面上保持一定的速度。
            //m_rigidBody.velocity = transform.forward * VSpeed;
        }
        //2、改变 速度和transform的方向
        TurnDir(90 * 0.01f * GameServices.inputService.joyStick.axisX.axisValue);
    }
    public void MoveType3()
    {
        characterController.SimpleMove(transform.forward * VSpeed* SpeedLevel);
        if (isGround1 || isGround2)
        {
            //在地面上才能控制移动
            transform.position += transform.right * GameServices.inputService.joyStick.axisX.axisValue * HSpeed * Time.deltaTime;
        }

       
        
    }

    /// <summary>
    /// 调整速度方向为路面的正向。
    /// </summary>
    public void AutoSpeedDir()
    {
        //调整速度方向为路面的正向。
        if (RHit.collider != null && RHit.collider.gameObject.transform.forward != transform.forward)
        {
            TurnDir(Vector3.Angle(transform.forward, RHit.collider.gameObject.transform.forward));
        }
    }


    //返回剩余物体个数
    public int GetLeftBoxNum()
    {
        int varIndex = 0;
        if (m_targetTrans != null)
        {
            for (int i = 0; i < m_targetTrans.Length; i++)
            {
                if (m_targetTrans[i].transform.position.y >= 2.0f)
                {
                    varIndex++;
                }
            }
        }
        return varIndex;
    }
    void Clicked()
    {
        if (m_bIsCanMove)
        {
            return;
        }
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                for (int i = 0; i < m_targetTrans.Length; i++)
                {
                    if (string.Equals(hit.collider.name, m_targetTrans[i].name))
                    {
                        m_curTargetTrans = m_targetTrans[i];
                        //重置状态
                        CancelDelayMoveHandle();
                        CancelRotateInvoke();
                        m_curTargetTrans.GetComponent<Rigidbody>().isKinematic = false;
                        break;
                    }
                }
               
                
            }
        }
    }
    void RotateTarget()
    {
        if (m_bIsCanMove)
        {
            return;
        }
        if (m_curTargetTrans)
        {
            m_curTargetTrans.transform.Rotate(transform.up, 90.0f);
        }
    }
 


    public void TurnDir(float angle)
    {
        transform.localEulerAngles += new Vector3(0, angle, 0);
        //m_rigidBody.velocity
        //Vector3 newVec = Quaternion.AngleAxis(angle, axis) * oriVec;
        //m_rigidBody.velocity = Quaternion.Euler(0, angle, 0) * m_rigidBody.velocity;
    }

    public void Vertigo(float time)
    {
        if(time> timerVertigo)
        {
            timerVertigo = time;   //不累加时长，单会更新时长。
        }
        
        //timerVertigo += time; //累加眩晕时长
    }

    private void OnControllerColliderHit(ControllerColliderHit hit)
    {

    }

    private void OnDestroy()
    {
        m_targetTrans = null;
        m_curTargetTrans = null;
        CancelDelayMoveHandle();
        CancelRotateInvoke();
        BattleCtrl.instance.turnDir -= TurnDir;
    }
}
