﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FloorBoard : MonoBehaviour
{

    private Object goldobj;
    void Start()
    {
        BattleCtrl.instance.randomGold += RandomGenerateGold;
        goldobj=Resources.Load(BattleCtrl.instance.GoldName);
        RandomGenerateGold();
    }

    // Update is called once per frame
    void Update()
    {
        
    }
    //随机生成金币。
    public void RandomGenerateGold()
    {
        float x = Random.Range(transform.position.x - transform.GetComponent<Collider>().bounds.size.x * 0.5f, transform.position.x + transform.GetComponent<Collider>().bounds.size.x * 0.5f);
        float z = Random.Range(transform.position.z - transform.GetComponent<Collider>().bounds.size.z * 0.5f, transform.position.z + transform.GetComponent<Collider>().bounds.size.z * 0.5f);
        GameObject obj= (GameObject)Instantiate(goldobj, new Vector3(x, transform.position.y + 1, z), transform.rotation);
        obj.transform.parent = transform;
    }

    private void OnDestroy()
    {
        BattleCtrl.instance.randomGold -= RandomGenerateGold;
    }
}
