﻿//战斗控制器,战斗场景的入口脚本
//using JBTree;
//using Common;
using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Assertions;
//using Common.Anim;

public class BattleCtrl : MonoBehaviour
{
    GameServices _GameServices;
    /// <summary>
    /// 游戏服务器
    /// </summary>
    public GameServices gameServices => _GameServices;

    public BattleUI battleUI;
    //public HomeUI homeUI;

    /// <summary>
    /// 关卡管理器
    /// </summary>
    public LevelManager m_levelManager;
    public LevelManager levelManager => m_levelManager;

    /// <summary>
    /// 场景加载器
    /// </summary>
    //public SceneLoadAsync sceneLoad = new SceneLoadAsync();

    bool _Inited;
    public bool inited => _Inited;

    bool _IsStartBattle;
    public bool isStartBattle => _IsStartBattle;

    bool _IsEndBattle;
    public bool isEndBattle => _IsEndBattle;

    static BattleCtrl _Instance;
    public static BattleCtrl instance => _Instance;

    public int Score = 0;

    public String GoldName = "Egg";  //金币名称（Resources）

    
    
    

    //更新分数
    public delegate void UpdateScoreDe();
    public UpdateScoreDe updateScore;
    //强制转弯
    public delegate void TurnDir(float angle);
    public TurnDir turnDir;
    //随机生成金币。
    public delegate void RandomGold();
    public RandomGold randomGold;
    //实时更新更新排行榜。
    public delegate void UpdateRanking();
    public UpdateRanking updateRanking;


    private void Awake()
    {
        
        _Instance = this;
        //Assert.IsNotNull(battleUI, "battleUI is null");
        InitServices();
        Init();
        //TinySauce.OnGameStarted();
    }

    void Start()
    {
        battleUI.onStartBtn += StartBattle;
    }



    void InitServices()
    {
        _GameServices = GameServices.Create();
        _GameServices.Init();
    }

    void Init()
    {
        //设置竖屏
        Screen.orientation = ScreenOrientation.Portrait;
        Screen.autorotateToPortrait = true;
        Screen.autorotateToPortraitUpsideDown = true;
        Screen.autorotateToLandscapeLeft = false;
        Screen.autorotateToLandscapeRight = false;
        //GameServices.inputService.DisableService();

        //预加载
        //ResourcesManager.PreLoad();

        //GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);

        m_levelManager.onBeforeLoadLevel += OnBeforeLoadLevel;

        m_levelManager.onAfterLoadLevel += OnAfterLoadLevel;

        LoadLevel(0);

        Application.targetFrameRate = 60;

        _Inited = true;
    }

    /// <summary>
    /// 开始战斗，点击了每个关卡的开始游戏按钮后调用
    /// </summary>
    void StartBattle()
    {
        //print("_IsStartBattle设置为true");
        _IsStartBattle = true;


        //if (curLevel.curLevelIndex == 0)//第一关，记录玩家选择的pien
        //{
        //    GlobalData.roleSelectData = homeUI.GetRoleSelectData();
        //    homeUI.gameObject.SetActive(false);
        //}

        //curLevel.OnStartBattle();
    }

    /// <summary>
    /// 战斗失败回调
    /// </summary>
    public void OnBattleFail()
    {
        _IsEndBattle = true;
        battleUI.OnBattleFail();
    }

    public void OnBattleWin()
    {
        _IsEndBattle = true;
        battleUI.OnBattleWin();
        int varCurTime = (int)levelManager.curLevel.bestTime;
        if(LocalRecord.HasKey(levelManager.CurLevelIndex.ToString()))
        {
            int varBestTime = LocalRecord.GetIntRecord(levelManager.CurLevelIndex.ToString());
            if (varCurTime < varBestTime)
            {
                LocalRecord.SetIntRecord(levelManager.CurLevelIndex.ToString(), varCurTime);
            }
        }
        else
        {
            LocalRecord.SetIntRecord(levelManager.CurLevelIndex.ToString(), varCurTime);
        }
        //curLevel.battleView.playerView.OnWin();
    }

    /// <summary>
    /// 加载关卡前调用
    /// </summary>
    public void OnBeforeLoadLevel()
    {
        _IsStartBattle = false;
        _IsEndBattle = false;
        battleUI.OnBeforeLoadLevel();
        //GameServices.inputService.DisableService();
    }

    /// <summary>
    /// 加载关卡后调用
    /// </summary>
    public void OnAfterLoadLevel()
    {
        battleUI.OnAfterLoadLevel();
    }

    /// <summary>
    /// 加载关卡
    /// </summary>
    /// <param name="levelIndex"></param>
    void LoadLevel(int levelIndex)
    {
        print("加载关卡："+levelIndex);
        m_levelManager.LoadLevel(levelIndex);
    }

    /// <summary>
    /// 加载回start场景
    /// </summary>
    //public void LoadStartScene()
    //{
    //    Camera.main.gameObject.SetActive(false);
    //    sceneLoad.LoadSceneAsync("StartScene");
    //}

    /// <summary>
    /// 显示提示可操作的ui
    /// </summary>
    //public void ShopTapToPlay()
    //{
    //    battleUI.ShowTapToPlay();
    //}

    //    void Update()
    //    {
    //        if (!inited)
    //            return;

    //        sceneLoad.OnUpdate();

    //#if UNITY_EDITOR
    //        if (Input.GetKeyDown(KeyCode.S))//停止pien的ai
    //        {
    //            GameServices.debugService.stopPienAi = !GameServices.debugService.stopPienAi;
    //        }
    //#endif
    //    }

    private void Update()
    {
        
    }
    
    

    private void OnDestroy()
    {
        m_levelManager.onBeforeLoadLevel -= OnBeforeLoadLevel;
        m_levelManager.onAfterLoadLevel -= OnAfterLoadLevel;
        battleUI.onStartBtn -= StartBattle;
        //battleUI.onStartBtn = null;
        _GameServices.OnDisponse();
        _GameServices = null;
        //m_levelManager.curLevel.OnDispose();
        //m_levelManager = null;
        //TinySauce.OnGameFinished(0);
    }

}
