﻿
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum WallType
{
    reward=10,
    punish=-10
}

/// <summary>
/// 随机控制经过wall的奖惩情况，并控制不同的材质球。
/// </summary>
public class Wall : MonoBehaviour
{
    public Material rewardMaterial; //奖励
    public Material punishMaterial;//惩罚

    private WallType type = WallType.reward;
    
    void Start()
    {
        int random=Random.Range(0, 2);  //0 1 不包括2
        //print("随机数："+random);
        if (random ==0)
        {
            this.type = WallType.punish;
            Renderer[] renders = GetComponentsInChildren<Renderer>();
            foreach (var i in renders)
            {
                i.material = punishMaterial;
            }
        }
        else if (random ==1)
        {
            this.type = WallType.reward;
            Renderer[] renders = GetComponentsInChildren<Renderer>();
            foreach (var i in renders)
            {
                i.material = rewardMaterial;
            }
        }
    }

    void Update()
    {
        //print("0或者1:"+Random.Range(0, 2));
        //print("[0,2)的小数:" + Random.Range(0.0f, 2.0f));
    }
    private void OnTriggerEnter(Collider other)
    {
        if (other.tag == "Player")
        {
            switch (type)
            {
                case WallType.reward: BattleCtrl.instance.Score += (int)WallType.reward; break;
                case WallType.punish: BattleCtrl.instance.Score += (int)WallType.punish; break;
                default: break;
            }
            //print("(int)WallType.reward:" + (int)WallType.reward);
            //print("(int)WallType.punish:" + (int)WallType.punish);
            BattleCtrl.instance.updateScore?.Invoke();
        }
    }
}
