﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Enemy_Vertigo : MonoBehaviour
{
    public float VSpeed = 40.0f;
    public int SpeedLevel = 1;
    public float AddSpeed = 10.0f;
    public float VertigoTime = 3.0f;

    private Transform targetPos;//目标点
    private CharacterController characterController;
    //动画
    private Animator animator;
    //状态
    private float MoveSpeed = 0.0f;
    private bool Grounded = false;


    void Start()
    {
        characterController = this.GetComponent<CharacterController>();
        targetPos = DoRanking._instance.rankingList[2].transform;
        //获取animator组件
        animator = GetComponentInChildren<Animator>();
    }

    // Update is called once per frame
    void Update()
    {
        
        Vector3 direction = (targetPos.position - transform.position);
        direction.y = 0;
        direction = direction.normalized;
        //characterController.SimpleMove(direction*Speed* SpeedLevel);
        characterController.Move(direction * (VSpeed+AddSpeed * SpeedLevel) * Time.deltaTime);
        
        //移动
        MoveSpeed = VSpeed+AddSpeed * SpeedLevel;
        //是否在地面
        Grounded = characterController.isGrounded;

        animator.SetFloat("MoveSpeed", MoveSpeed);
        animator.SetBool("Grounded", Grounded);
    }


    private void OnControllerColliderHit(ControllerColliderHit hit)
    {
        
        if (hit.collider.tag == "Competitor")
        {
            hit.gameObject.GetComponent<AIMove>().Vertigo(VertigoTime);//眩晕1秒
            Destroy(gameObject);
        }
        if (hit.collider.tag == "Player")
        {
            hit.gameObject.GetComponent<PlayerMove>().Vertigo(VertigoTime);//眩晕1秒
            Destroy(gameObject);
        }
    }
}
