﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DoRanking : MonoBehaviour
{
    public List<GameObject> rankingList; //需要排行的人物。
    public float updateTime = 0.2f;   //更新时间间隔

    private float timer = 0;

    public static DoRanking _instance;
    private GameObject tempGO;
    private void Awake()
    {
        _instance = this;
    }
    void Start()
    {
        tempGO = new GameObject();
        tempGO.SetActive(false);
        BattleCtrl.instance.updateRanking += UpdateRanking;
    }

    // Update is called once per frame
    void Update()
    {
        timer += Time.deltaTime;
        if(timer>= updateTime)
        {
            timer = 0.0f;
            BattleCtrl.instance.updateRanking?.Invoke();
        }

           
    }
    //冒泡排序z值从小到大。
    public List<GameObject> DoRankingFun(List<GameObject> list)
    {
        GameObject temp = tempGO;
        for (int i = 0; i < list.Count; i++)
        {
            for (int j = 0; j < list.Count - i - 1; j++)
            {
                //if (list[j].transform.position.z > list[j + 1].transform.position.z)  //保留一位小数
                if (Math.Round(list[j].transform.position.z, 1) > Math.Round(list[j + 1].transform.position.z,1))  //保留一位小数
                {
                    temp = list[j];
                    list[j] = list[j + 1];
                    list[j + 1] = temp;
                }
            }
        }
        return list;
    }
    public void UpdateRanking()
    {
        rankingList = DoRankingFun(rankingList);
    }
    private void OnDestroy()
    {
        Destroy(tempGO);
        BattleCtrl.instance.updateRanking -= UpdateRanking;
    }
}
