﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Enemy_Vertigo : MonoBehaviour
{
    public float Speed = 40.0f;
    public int SpeedLevel = 1;
    public float VertigoTime = 3.0f;

    private Transform targetPos;//目标点
    private CharacterController characterController;


    void Start()
    {
        characterController = this.GetComponent<CharacterController>();
    }

    // Update is called once per frame
    void Update()
    {
        targetPos = DoRanking._instance.rankingList[2].transform;
        Vector3 direction = (targetPos.position - transform.position);
        direction.y = 0;
        direction = direction.normalized;
        //characterController.SimpleMove(direction*Speed* SpeedLevel);
        characterController.Move(direction * Speed * SpeedLevel * Time.deltaTime);
    }


    private void OnControllerColliderHit(ControllerColliderHit hit)
    {
        
        if (hit.collider.tag == "Competitor")
        {
            hit.gameObject.GetComponent<AIMove>().Vertigo(VertigoTime);//眩晕1秒
            Destroy(gameObject);
        }
        if (hit.collider.tag == "Player")
        {
            hit.gameObject.GetComponent<PlayerMove>().Vertigo(VertigoTime);//眩晕1秒
            Destroy(gameObject);
        }
    }
}
