﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public delegate void OnMoveVec2(Vector2 dir);
public delegate void OnMoveVec3(Vector3 dir);
public delegate void OnStop();
public delegate void OnClick();

public class BattleJoinPad : MonoBehaviour
{
    //public Transform joinPadView;
    //public Image joinPadBall;

    public float rotationAngle = 45;

    float doubleClickCD = 2;

    public float lastPointerUpTime;
    public float lastExecuteTime;

    /// <summary>
    /// 输入服务启用时，操作才有效
    /// </summary>
    public bool optValid = true;

    public OnMoveVec2 onMove;
    public OnMoveVec3 onMoveVec3;
    public OnStop onTouchUp;
    public OnClick onClickDown;

    public void SetOptValid(bool valid)
    {
        optValid = valid;
    }

    public void SetPosition(Vector2 position)
    {
        //this.joinPadView.localPosition = position;
    }

    public void ResetPosition(bool stopMove)
    {
        // 仅在停止时，方向小球回复初始位置
        if (stopMove)
        {
            //this.joinPadBall.transform.localPosition = Vector3.zero;
        }
    }

    float m_PointDownTime;
    public void OnFingerPointerDown()
    {
        m_PointDownTime = Time.realtimeSinceStartup;
        this.PostOnClick();
    }

    float m_PointDownTime2;
    /// <summary>
    /// 第二个手指点下
    /// </summary>
    public void OnFinger2PointerDown()
    {
        m_PointDownTime2 = Time.realtimeSinceStartup;
    }

    public const float defaultJudgeAttackTime = 0.24f;
    public float JudgeAttackTime = defaultJudgeAttackTime;
    public const float defaultJudgeMoveTime = 0f;//0.1f;
    public float JudgeMoveTime = defaultJudgeMoveTime;

    /// <summary>
    /// 新增AutoRun模式 手指抬起事件
    /// </summary>
    public void OnFingerTouchUp()
    {
        float touchTime = Time.realtimeSinceStartup - m_PointDownTime;

        if (touchTime >= JudgeMoveTime)
        {
            this.PostOptStopMove();
        }
    }

    public void OnFinger2TouchUp()
    {
        if (!optValid)
            return;
        onTouchUp?.Invoke();
    }

    public void SetBallOffset(Vector2 offset)
    {
        if (onMoveVec3 != null)
        {
            onMoveVec3(offset);
        }
        //this.joinPadBall.transform.localPosition = new Vector3(offset.x, offset.y, 0);
        //this.PostOptMove(TransformMoveDir(offset));
    }

    private Vector2 TransformMoveDir(Vector2 dir)
    {
        return dir;
    }

    public void ShowView()
    {
        //joinPadView.gameObject.SetActive(true);
    }
    public void HideView()
    {
        //joinPadView.gameObject.SetActive(false);
    }

    bool m_IfCouldMove = true;
    public bool IfCouldMove
    {
        get {
            return m_IfCouldMove;
        }
        set {
            m_IfCouldMove = value;
        }
    }
    /// <summary>
	/// 发送移动操作事件
    /// </summary>
    private void PostOptMove(Vector2 moveDir)
    {
        if (!optValid)
            return;

        if (onMove != null)
            onMove(moveDir.normalized);
        if (onMoveVec3 != null)
        {
            onMoveVec3(ToVec3(moveDir.normalized));
        }
        else
        {
            Debug.Log("onMoveVec3 is null");
        }
    }

    Vector3 ToVec3(Vector2 dir)
    {
        return new Vector3(dir.x,0, dir.y);
    }

    /// <summary>
    /// 发送移动停止事件
    /// </summary>
    private void PostOptStopMove()
    {
        if (!optValid)
            return;

        onTouchUp?.Invoke();
    }

    void PostOnClick()
    {
        onClickDown?.Invoke();
    }
    
    public void ResetPadView()
    {
        //joinPadView.transform.localPosition = Vector3.zero;
    }

    public void ResetPointId()
    {
        transform.GetComponentInChildren<BattleJoinPadEvent2>().ResetPointId();
    }

    void OnDestroy()
    {
        onMove = null;
        onTouchUp = null;
        onMoveVec3 = null;
        onClickDown = null;
    }

}