// Unity built-in shader source. Copyright (c) 2016 Unity Technologies. MIT license (see license.txt)

// Unlit alpha-cutout shader.
// - no lighting
// - no lightmap support
// - no per-material color

Shader "Custom/UnlitFillAlphaTest" {
Properties {
    _MainTex ("Base (RGB) Trans (A)", 2D) = "white" {}
    _Cutoff ("Alpha cutoff", Range(0,1)) = 0.5

	_Color("Main Color",Color) = (0,0,1,1)
	_FillBeginPos("Fill Begin",vector) = (0,0,0,0)
	_FillEndPos("Fill End",vector) = (0,2,0,0)
	_FillValue("Fill Value", Range(0,1)) = 0.5
	_FillColor("Fill Color",Color) = (0,0,1,1)

	_BrightInFill("Bright In Fill",float) = 1
}
SubShader {
    Tags {"Queue"="AlphaTest" "IgnoreProjector"="True" "RenderType"="TransparentCutout"}
    LOD 100

    ZTest Off
    Blend SrcAlpha OneMinusSrcAlpha
    Lighting Off

    Pass {
        CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            #pragma target 2.0

            #include "UnityCG.cginc"

            struct appdata_t {
                float4 vertex : POSITION;
                float2 texcoord : TEXCOORD0;
				UNITY_VERTEX_INPUT_INSTANCE_ID
            };

            struct v2f {
                float4 vertex : SV_POSITION;
                float2 texcoord : TEXCOORD0;

				float4 worldPos:TEXCOORD1;
                UNITY_VERTEX_OUTPUT_STEREO
            };

            sampler2D _MainTex;
            float4 _MainTex_ST;
            fixed _Cutoff;

			float4 _FillBeginPos;
			float4 _FillEndPos;
			float _FillValue;
			fixed4	_FillColor;
			fixed4	_Color;

			float _BrightInFill;

            v2f vert (appdata_t v)
            {
                v2f o;
                UNITY_SETUP_INSTANCE_ID(v);
                UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.texcoord = TRANSFORM_TEX(v.texcoord, _MainTex);
				o.worldPos = mul(unity_ObjectToWorld, v.vertex);
                return o;
            }

            fixed4 frag (v2f i) : SV_Target
            {
                fixed4 col = tex2D(_MainTex, i.texcoord);
                clip(col.a - _Cutoff);
                col *= _Color;

				float4 curFillPos = _FillBeginPos + (_FillEndPos - _FillBeginPos) * _FillValue;
				float4 dir = _FillEndPos - _FillBeginPos;
				float4 curDir = i.worldPos - curFillPos;

				//float originalAlpha = col.a;

				int temp = step(0.001,dot(dir, curDir));
				col *= _FillColor * (1-temp)  * _BrightInFill + temp;
				//col.a = originalAlpha;
                return col;
            }
        ENDCG
    }
}

}
