﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HoppingGameData :GameData
{
    private HoppingGameUser m_HoppingGameUser;
    public override GameUser user
    {
        get { return m_HoppingGameUser;}
        set { m_HoppingGameUser = value as HoppingGameUser; }
    }

    public HoppingGameData()
    {
        m_HoppingGameUser = new HoppingGameUser();
    }
}

public class HoppingGame : Game
{
    [SerializeField]
    private HoppingDataConfig m_DataConfig;

    public override DataConfig dataConfig => m_DataConfig;
    protected override GameData InitGameData()
    {
        HoppingGameData hoppingGameData = new HoppingGameData();
        
        HoppingLocalUserData localUserData = null;
        if (PlayerPrefs.HasKey(LocalUserDataKey))
        {
            string data = PlayerPrefs.GetString(LocalUserDataKey);
            GameDebug.Log($"读取本地数据：{data}");
            localUserData = Newtonsoft.Json.JsonConvert.DeserializeObject<HoppingLocalUserData>(data);
        }
        else
        {
            localUserData = new HoppingLocalUserData();
            localUserData.InitTestData();

            string dataStr = Newtonsoft.Json.JsonConvert.SerializeObject(localUserData);
            PlayerPrefs.SetString(LocalUserDataKey,dataStr);
        }
        
        hoppingGameData.user.Init(localUserData);
#if Test  
        localUserData = new HCTWLocalUserData();
        localUserData.InitTestData();
#endif
        return hoppingGameData;
    }

    public override BattleController NewBattleController()
    {
        return new GameObject("BattleController").AddComponent<HoppingBattleController>(); 
    }
}
